function cal_curvature(x,y,l)

global others results;

xrange=abs(x(1,end)-x(1,1));
yrange=abs(y(1,end)-y(1,1));

n=length(x(1,:));
m=length(results);

for i=1:m,
 t(i,1:n)=results(i).time;
 vc(i,1:n)=0;
end

h=waitbar(0,'Calculating curvature ...');
b=0;
for k=1:others.itermax,
    vc_old=vc;
    if xrange>yrange
        for i=1:m,
            [y(i,:),p]=smoothcoeff(x(i,:),y(i,:),others.sfac);
            b=b+1;
            vc(i,:)=curvature(x(i,:),p);
            verr(i)=max(abs((vc(i,:)-vc_old(i,:))./(mean(vc(i,:))+eps)));
            waitbar(min(1,b/(others.itermax*m)));
        end
    else
        for i=1:m,
            [x(i,:),p]=smoothcoeff(y(i,:),x(i,:),others.sfac);
            b=b+1;
            vc(i,:)=curvature(y(i,:),p);
            verr(i)=max(abs((vc(i,:)-vc_old(i,:))./(mean(vc(i,:))+eps)));
            waitbar(min(1,b/(others.itermax*m)));
        end
    end
    for i=1:m,
      for j=length(x(i,:)):-1:1,
        if l(i,j)<1.5
            vc(i,j)=vc(i,j+1)-abs(vc(i,j+2)-vc(i,j+1));
            if vc(i,j)<0
                vc(i,j)=0;
            end
        end
      end
    end
%     for i=1:m,
%          s=l(i,2:end)-l(i,1:end-1);
%          vx=x(i,2:end)-x(i,1:end-1);
%          vy=y(i,2:end)-y(i,1:end-1);
%          v=sqrt(vx.*vx+vy.*vy);
%          vx(1:n-1)=vx(1:n-1)./v(1:n-1);
%          vy(1:n-1)=vy(1:n-1)./v(1:n-1); 
%          vx(n)=vx(n-1);
%          vy(n)=vy(n-1);
%          angle(1:n-1)=acos(min(1,vx(1:n-1).*vx(2:n)+vy(1:n-1).*vy(2:n)));
%          vc(i,1:n-1)=angle./s;
%          verr(i)=max(abs((vc(i,1:n-1)-vc_old(i,1:n-1))./(mean(vc(i,1:n-1))+eps)));
%     end
    if max(verr)<others.conv_crit
        break;
    end
end
waitbar(1.0,h,'Completed');
close(h);


others.x=l(:,:);
others.p=vc(:,:);
others.t=t(:,:);

return