function cal_growthrate(x)

global others results;

n=length(x(1,:));
m=length(results);

for i=1:m,
 t(i,1:n)=results(i).time;
 vc(i,1:n)=0;
end

h=waitbar(0,'Calculating growth rate ...');
b=0;
for k=1:others.itermax,
    vc_old=vc;
    for j=1:n,
        x(:,j)=smooth(t(:,j),x(:,j),others.sfac);
        b=b+1;
        waitbar(min(1,b/(others.itermax*n)));
    end
    if m>=3,
        vc(1,:)=(4*x(2,:)-3*x(1,:)-x(3,:))./(t(3,:)-t(1,:));
        for i=2:m-1,
            vc(i,:)=(x(i+1,:)-x(i-1,:))./(t(i+1,:)-t(i-1,:));
        end
        vc(m,:)=(4*x(m-1,:)-3*x(m,:)-x(m-2,:))./(t(m,:)-t(m-2,:));
        for i=1:m,
            verr(i)=max(abs((vc(i,2:end)-vc_old(i,2:end))./(mean(vc(i,2:end))+eps)));
        end
    else
        for i=2:m,
            vc(i,:)=(x(i,:)-x(i-1,:))./(t(i,:)-t(i-1,:));
            verr(i)=max(abs((vc(i,2:end)-vc_old(i,2:end))./(mean(vc(i,2:end))+eps)));
        end
    end
    
    if max(verr)<others.conv_crit
        break;
    end
end
waitbar(1.0,h,'Completed');
close(h);

% for i=1:m,
%     for j=2:n,
%         if vc(i,j)<0
%             vc(i,j)=0;
%         end
%     end
% end

others.x=x(1:m,:);
others.p=vc(1:m,:);
others.t=t(1:m,:);

return