function createplaybuttons

 global hdl img others;
 
 %0.01 0.15 0.8 0.84
 
 pos = [0.01 0.052 0.07 0.04]; %(array variable)
 hdl.playbtn=uicontrol(hdl.figure,'Style','Pushbutton', ...
    'Units','normalized','ForegroundColor',[0 0 0],'BackgroundColor',[1 1 1],...
    'FontWeight','Bold','Position',pos,'string','Play', ...
    'callback','play_cb(''playfigure'')');

 pos = [0.1 0.052 0.07 0.04]; %(array variable)
 hdl.pausebtn=uicontrol(hdl.figure,'Style','Pushbutton', ...
    'Units','normalized','ForegroundColor',[0 0 0],'BackgroundColor',[1 1 1],...
    'FontWeight','Bold','Position',pos,'string','Pause', ...
    'callback','play_cb(''pausemovie'')');

pos = [0.19 0.052 0.07 0.04]; %(array variable)
hdl.savemoviebtn=uicontrol(hdl.figure,'Style','Pushbutton', ...
    'Units','normalized','ForegroundColor',[0 0 0],'BackgroundColor',[1 1 1],...
    'FontWeight','Bold','Position',pos,'string','Save Movie', ...
    'callback','play_cb(''savemovie'')');

others.slowness=0.0;
pos = [0.28 0.052 0.07 0.04];
 hdl.slowertext=uicontrol(hdl.figure,'Style','Text', ...
    'Units','normalized','ForegroundColor',[0 0 0],'BackgroundColor',[0.8 0.8 0.8],...
    'FontWeight','Bold','Position',pos,'HorizontalAlignment','center',...
    'string','0% slower');

pos = [0.40 0.052 0.11 0.04];
 hdl.slowerslider=uicontrol(hdl.figure,'Style','Slider', ...
    'Units','normalized','ForegroundColor',[0 0 0],'BackgroundColor',[0.8 0.8 0.8],...
    'FontWeight','Bold','Position',pos, ...
    'callback','play_cb(''slowslider'')','Min',0.0,'Max',1.0, ...
    'SliderStep',[0.01 0.1]);

nimage=length(img);
if nimage > 0,
        sliderstep=[1/nimage,min(1,10/nimage)];
else
        sliderstep=[0.01,1];
end
pos = [0.01 0.005 0.5 0.04];
 hdl.playslider=uicontrol(hdl.figure,'Style','Slider', ...
    'Units','normalized','ForegroundColor',[0 0 0],'BackgroundColor',[0.8 0.8 0.8],...
    'FontWeight','Bold','Position',pos,'HorizontalAlignment','center', ...
    'Min',1,'Max',max(nimage,2),'SliderStep',sliderstep, ...
    'callback','play_cb(''playslider'')');

if nimage<=1,
    set(hdl.playslider,'enable','inactive');
else
    set(hdl.playslider,'enable','on');
end