function file_loading_cb(action, varargin)

global hdl;

if nargin>=1,
feval(action,varargin{:});
end
return;

%=====================

function closewindow

global hdl;

close(hdl.figure)
return

%=====================

function filetemplate

global hdl;

[filename, directory] =uigetfile('*.jpg;*.jpeg;*.tif;*.tiff', ...
                                 'Select first file');

if filename==0
    return
end

cd(directory);
str = sprintf('%s%s',directory, filename);
set(hdl.filetemplate,'string',str);

return

%====================

function openfiles

global hdl img others;

others.pauseflag=0;

% | = or
% ~= = not equals to

filename=get(hdl.filetemplate,'string'); %(from filetemplate.m)

fn1=str2num(get(hdl.firstfiletext,'string'));
fns=str2num(get(hdl.steptext,'string'));
fn2=str2num(get(hdl.lastfiletext,'string'));

if fn1==fn2
   if exist(filename,'file'),
     img(1).seqno=1;
     fname=sscanf(filename(end:-1:1),'%[^\\^/]');
     fname=fname(end:-1:1);
     img(1).filename=fname;
     img(1).image=imread(filename); %(read filename)
     img(1).npts=0;
     img(1).edge_flag=0;
     img(1).cen_x=[];
     img(1).cen_y=[];
     others.roottip=0;
     others.cimage=1;    
     others.color=iscolor(img(1).image);
   else
     str=sprintf('File "%s" not found',filename);
     warndlg(str,'File not found');
     return
   end 

    close(hdl.figure);
    mainwindow;
    return
end

nn=findstr(filename,'#');

if isempty(nn),
    warndlg('Please identify the sequence no. in the template with #', 'File template error');
    return;
end

fname1=filename(1:nn(1)-1);
fname2=filename(nn(end)+1: end);

%str2num converts string to integer

h=mywaitbar(0,'Loading files, please wait ...');
nfc=length(fn1:fns:fn2);
n=0;
for i=fn1:fns:fn2,
    if length(nn)==1,
    	filenames=sprintf('%s%d%s',fname1,i,fname2);
    elseif length(nn)==2,
    	filenames=sprintf('%s%02d%s',fname1,i,fname2);
    elseif length(nn)==3,
        filenames=sprintf('%s%03d%s',fname1,i,fname2);
    elseif length(nn)==4,
        filenames=sprintf('%s%04d%s',fname1,i,fname2);
    elseif length(nn)==5,
        filenames=sprintf('%s%05d%s',fname1,i,fname2);
    elseif length(nn)==6,
        filenames=sprintf('%s%06d%s',fname1,i,fname2);
    end
    fname=sscanf(filenames(end:-1:1),'%[^\\^/]');
    fname=fname(end:-1:1);
    if exist(filenames,'file'),
     n=n+1;
     img(n).seqno=i;
     img(n).filename=fname;
     img(n).image=imread(filenames);
     img(n).npts=0;
     img(n).edge_flag=0;
     img(n).cen_x=[];
     img(n).cen_y=[];
     mywaitbar(n/nfc);
    else
     str=sprintf('%s not found',filenames);
     disp(str);   
    end
end
close(h);

if n>0
  close(hdl.figure); %(from closewindow funtion)
  others.cimage=1;
  others.roottip=0;
  others.color=iscolor(img(1).image);
  mainwindow;
end
return

