function imagedraw(n)

global img hdl others;


set(0,'currentfigure',hdl.figure);
axes(hdl.axis);

a=axis;
imagesc(img(n).image);
axis tight
axis equal
if a~=[0 1 0 1],
    axis(a);
end

axis off

str = sprintf('Image No. %d (time=%.1f %s): %s', ...
               n, img(n).time, others.timeunit, img(n).filename);
title(texlabel(str, 'literal'));

set(hdl.playslider,'value',n);
set(hdl.col_channel_check,'value',0);
colormap(others.colormap);
% drawnow;

hdl.pts=-1;
hdl.roottippt=-1;
hdl.scaleline=-1;
hdl.diaestline=-1;
hdl.outline=-1;
hdl.centerline=-1;
hdl.rootcolorline=-1;
hdl.bgcolorline=-1;

return