function mainwindow

global hdl img others results;

pos=get(0,'screensize');
imsize=size(img(others.cimage).image);
w=max(min(pos(3)-200,imsize(2)+200),900);
h=max(min(pos(4)-200,imsize(1)+100),700);
pos(1)=pos(3)/2-w/2;
pos(2)=pos(4)/2-h/2;
pos(3)=w;
pos(4)=h;

hdl.figure=figure('name','Kinematic analysis','doublebuffer','on', ...
    'position',pos,'toolbar','figure');
others.colormap=whichcolor(others.color);


pos = [0.01 0.095 0.8 0.84];
hdl.axis=axes('Position', pos,'Units','normalized');

if others.scaleflag==0,
    others.scale=1;
    others.unitvalue=4;
    others.unit='px';
    others.matunit='px';
    others.period=3;
    others.periodunit=3;
    others.timeunit='min';
end

others.filterrad=4;
others.diaest=-1.0;
others.nseg=50;
others.intpts=25;
for i=1:length(img),
    img(i).time=(i-1)*others.period;
end

others.midline=1;

others.pts_show=4;
others.outline_show=4;
others.centerline_show=4;
others.roottip_show=2;

others.rootcolor=[0.6 0.6 0.6];
others.bgcolor=[0.07 0.2 0.4];

createplaybuttons;
scale_buttons;
createanalysisbuttons;
imagedraw(others.cimage);


return


