function [nonmax,ax,ay]= nonmaxsup_line_edge(a,sigma)
% nonmaxsup : provide image and sigma

sig=sigma;
a = double(a);
[m,n] = size(a);
e = zeros(m,n);
z = 1:30; 
  sigma_sq = sig^2;
  w = find(exp(-(z.*z)/(2*sigma_sq))>0.0001,1,'last');
  if isempty(w)
    w = 1;  
  end

  [x,y]=meshgrid(-w:w,-w:w);
  t = (-w:w);
  gauss = exp(-(t.*t)/(2*sigma_sq))/(2*pi*sigma_sq);     
  
  dgauss2D=-x.*exp(-(x.*x+y.*y)/(2*sigma_sq))/(pi*sigma_sq);
    
    a_f=conv2(a,gauss,'same');   
    aSmooth=conv2(a_f,gauss','same'); 
%     
%   ax = conv2(aSmooth, dgauss2D, 'same');
%   ay = conv2(aSmooth, dgauss2D', 'same');
%   
%   axx=ax;
%   ayy=ay;
  
  ax=0*a;
  ay=ax;
  
  ax(3:end-2,:)=(16*aSmooth(2:end-3,:)-30*aSmooth(3:end-2,:)+16*aSmooth(4:end-1,:)- ...
      aSmooth(1:end-4,:)-aSmooth(5:end,:))/12;
  ay(:,3:end-2)=(16*aSmooth(:,2:end-3)-30*aSmooth(:,3:end-2)+16*aSmooth(:,4:end-1)- ...
      aSmooth(:,1:end-4)-aSmooth(:,5:end))/12;
  
  mag = sqrt((ax.*ax) + (ay.*ay));
  max_mag = max(mag(:));
  if max_mag>0
    mag = mag / max_mag;   
  end
 
  for quad = 1:4
    LocalMax = FLocMax(quad,ax,ay,mag);
    e(LocalMax)= mag(LocalMax);
  end
  nonmax=e;
  

