function pickbgcolor(action, varargin)

global hdl;
%exclusive radio buttons
h1=gcbo;
if strncmpi(get(h1,'Type'),'uicontrol',4)==1,
 if strncmpi(get(h1,'Style'),'radiobutton',4)==1,
    h=findobj(hdl.figure,'style','radiobutton','Tag','clickndraw');
    for i=1:length(h),
     if eq(h(i),h1)==0 & eq(h(i),hdl.trackdirectional)==0,
       set(h(i),'value',0);
     end
    end
%     zoom off;
%     set(hdl.zoom,'value',[0],'Foreground',[0 0 0]);
 end
end

if nargin>=1,
 feval(action,varargin{:});
end

return;

%
%================
%

function bgcolor

global hdl;

if hdl.bgcolorline > 0.0,
    delete(hdl.bgcolorline);
    hdl.bgcolorline=-1;
end
mes_flag=get(hdl.bgcolor,'Value');
if mes_flag==1
 set(hdl.figure, 'WindowButtonDownFcn', 'pickbgcolor(''ButtonDownOnMano'')');
end

return

%
%================
%

function ButtonDownOnMano

global hdl others;

pt = get(gca, 'CurrentPoint');
others.rcbox_x0 = pt(1,1); 
others.rcbox_y0 = pt(1,2); 
others.rcbox_x1 = others.rcbox_x0;
others.rcbox_y1 = others.rcbox_y0;
hdl.bgcolorline=line([others.rcbox_x0, others.rcbox_x1, others.rcbox_x1, ...
    others.rcbox_x0, others.rcbox_x0],...
    [others.rcbox_y0, others.rcbox_y0, others.rcbox_y1, others.rcbox_y1, ...
    others.rcbox_y0],'erasemode', 'xor');
set(hdl.figure, 'WindowButtonMotionFcn', 'pickbgcolor(''DrawLine'')');
set(hdl.figure, 'WindowButtonUpFcn', 'pickbgcolor(''BackToNormalcy'')');

return


function DrawLine

global hdl others;

 if hdl.bgcolorline>0.0
  delete(hdl.bgcolorline);
 end

 pt = get(gca, 'CurrentPoint');
 others.rcbox_x1 = pt(1,1); 
 others.rcbox_y1 = pt(1,2);
 hdl.bgcolorline=line([others.rcbox_x0, others.rcbox_x1, others.rcbox_x1, ...
    others.rcbox_x0, others.rcbox_x0],...
    [others.rcbox_y0, others.rcbox_y0, others.rcbox_y1, others.rcbox_y1, ...
    others.rcbox_y0],'erasemode', 'xor');
return

%%%
%%%  Sub-function - BackToNormalcy
%%%

function BackToNormalcy

global others hdl img;

if hdl.bgcolorline >0.0
 delete(hdl.bgcolorline);
 hdl.bgcolorline=-1;
end

set(hdl.figure, 'WindowButtonDownFcn', '');
set(hdl.figure, 'WindowButtonMotionFcn', '');
set(hdl.figure, 'WindowButtonUpFcn', '');

x0=round(others.rcbox_x0);
y0=round(others.rcbox_y0);
x1=round(others.rcbox_x1);
y1=round(others.rcbox_y1);

others.bgcolor=mean(mean(img(others.cimage).image(min(y0,y1):max(y0,y1),min(x0,x1):max(x0,x1),:)));
if max(others.bgcolor)>1
    others.bgcolor=others.bgcolor/255;
end

if max(others.bgcolor) < 0.5,
 fgcolor=[1 1 1];
else
 fgcolor=[0 0 0];
end

set(hdl.bgcolor,'Value',0,'Background',others.bgcolor,'Foreground',fgcolor);

return