function pickpts_cb(action, varargin)

global hdl;

%exclusive radio buttons
h1=gcbo;
if strncmpi(get(h1,'Type'),'uicontrol',4)==1,
 if strncmpi(get(h1,'Style'),'radiobutton',4)==1,
    h=findobj(hdl.figure,'style','radiobutton','Tag','clickndraw');
    for i=1:length(h),
     if eq(h(i),h1)==0 & eq(h(i),hdl.trackdirectional)==0,
       set(h(i),'value',0);
     end
    end
    zoom off;
%     set(hdl.zoom,'value',[0],'Foreground',[0 0 0]);
 end
end

if nargin>=1,
feval(action,varargin{:});
end
return;

%=====================

function pickpts

global hdl img others;

if get(hdl.pickpts,'value'),
 zoom off
 set(hdl.figure, 'WindowButtonDownFcn', 'pickpts_cb(''pickpts_ButtonDown'')');
end
return

%====================

function pickpts_ButtonDown

global hdl img others;

if strncmp(get(gcf, 'SelectionType'),'normal',6) ~=1,
 set(hdl.figure, 'WindowButtonDownFcn', '');
 set(hdl.pickpts, 'Value', 0);
 return
end
m=others.cimage;
imgsize=size(img(m).image);
pt=round(get(gca, 'CurrentPoint'));
if pt(1,1)>=1 & pt(1,1)<=imgsize(2) & pt(1,2)>=1 & pt(1,2)<=imgsize(1),
   img(m).npts=img(m).npts+1;
   img(m).ptsx(img(m).npts)=pt(1,1);
   img(m).ptsy(img(m).npts)=pt(1,2);
   img(m).picked_ptsx(img(m).npts)=img(m).ptsx(img(m).npts);
   img(m).picked_ptsy(img(m).npts)=img(m).ptsy(img(m).npts);
   img(m).cc(img(m).npts)=1;
   img(m).edge_flag=0;
   drawothers(m);
end
if img(m).npts>25
    others.nseg=img(m).npts;
    others.intpts=img(m).npts;
end
return

%====================

function movepts

global hdl img others;

m=others.cimage;

if get(hdl.movepts,'value')==0 | img(m).npts==0 | hdl.pts<0,
    set(hdl.movepts,'value',0);
    return
end
set(hdl.figure, 'WindowButtonDownFcn', 'pickpts_cb(''movepts_ButtonDown'')');

return

%=====================================================

function movepts_ButtonDown

global hdl img others;

if strncmp(get(gcf, 'SelectionType'),'normal',6) ~=1,
 set(hdl.figure, 'WindowButtonDownFcn', '');
 set(hdl.movepts, 'Value', 0);
 return
end

m=others.cimage;

pt=round(get(gca, 'CurrentPoint'));
dist=25;
others.pickedpt=0;
for i=1:img(m).npts,
 d=(img(m).ptsx(i)-pt(1,1))^2+(img(m).ptsy(i)-pt(1,2))^2;
 if d<dist,
  dist=d;
  others.pickedpt=i;
 end
end

if others.pickedpt==0,
 return
end

set(hdl.figure, 'WindowButtonMotionFcn', 'pickpts_cb(''movepts_redraw'')');
set(hdl.figure, 'WindowButtonUpFcn', 'pickpts_cb(''movepts_final'')');

return

%=====================================================

function movepts_redraw

global hdl img others;

if strncmp(get(gcf, 'SelectionType'),'normal',6) ~=1,
 set(hdl.figure, 'WindowButtonDownFcn', '');
 set(hdl.movepts, 'Value', 0);
 return
end

m=others.cimage;
n=others.pickedpt;

pt=round(get(gca, 'CurrentPoint'));
i=others.pickedpt;
imgsize=size(img(others.cimage).image);
if pt(1,1)>=1 & pt(1,1)<=imgsize(2) & pt(1,2)>=1 & pt(1,2)<=imgsize(1),
 img(m).ptsx(n) = pt(1,1);
 img(m).ptsy(n) = pt(1,2);
 img(m).picked_ptsx(n) = pt(1,1);
 img(m).picked_ptsy(n) = pt(1,2);
end
drawothers(m);

return

%======================================================

function movepts_final

global hdl img others;
                                                                                                                  
if strncmp(get(gcf, 'SelectionType'),'normal',6) ~=1,
 set(hdl.figure, 'WindowButtonDownFcn', '');
 set(hdl.movepts, 'Value', 0);
 return
end
                                                                                                                  
m=others.cimage;
n=others.pickedpt;
imgsize=size(img(others.cimage).image);

pt=round(get(gca, 'CurrentPoint'));

i=others.pickedpt;
if pt(1,1)>=1 & pt(1,1)<=imgsize(2) & pt(1,2)>=1 & pt(1,2)<=imgsize(1),
 img(m).ptsx(n) = pt(1,1);
 img(m).ptsy(n) = pt(1,2);
 img(m).picked_ptsx(n) = pt(1,1);
 img(m).picked_ptsy(n) = pt(1,2);
end
drawothers(m);


set(hdl.figure, 'WindowButtonMotionFcn','');
set(hdl.figure, 'WindowButtonUpFcn','');

return

%====================================================

function resetall

global hdl img others;

quest=questdlg('Are you sure, you want to delete all points for this image? This will also delete the root outlines for this image.','Delete points?','Yes','No','No');

switch quest,
    case 'Yes'
        for m=1:length(img);                                                                                                
            img(m).ptsx = [];
            img(m).ptsy = [];
            img(m).picked_ptsx = [];
            img(m).picked_ptsy = [];
            img(m).rootdia1x=[];
            img(m).rootdia1y=[];
            img(m).rootdia2x=[];
            img(m).rootdia2y=[];
            img(m).cen_x=[];
            img(m).cen_y=[];
            img(m).npts=0;
            img(m).edge_flag=0;
            others.roottip=0;
        end
        drawothers(m);
    case 'No',
        return
end

return

%====================================================

function optimizepts

global hdl img others;

m=others.cimage;
n=img(m).npts;
p=size(img(m).image);

opt=get(hdl.optimizetemplate,'value');
gimage=abs(gradient(mean(double(img(m).image),3)));

for i=1:n,
    x=img(m).ptsx(i);
    y=img(m).ptsy(i);
    xmin=max(1,x-opt);
    xmax=min(p(2),x+opt);
    ymin=max(1,y-opt);
    ymax=min(p(1),y+opt);

    min_gimg=gimage(y,x);
    for ix=xmin:xmax,
        for iy=ymin:ymax,
            if gimage(iy,ix)>min_gimg,
                img(m).ptsx(i)=ix;
                img(m).ptsy(i)=iy;
            end
        end
    end
end

drawothers(m);
    
return

%====================

function roottip

global hdl img others;

m=others.cimage;

if get(hdl.roottip,'value')==0 | img(m).npts==0 | hdl.pts<0,
    set(hdl.roottip,'value',0);
    return
end
set(hdl.figure, 'WindowButtonDownFcn', 'pickpts_cb(''roottip_ButtonDown'')');

return

%=====================================================

function roottip_ButtonDown

global hdl img others;

if strncmp(get(gcf, 'SelectionType'),'normal',6) ~=1,
 set(hdl.figure, 'WindowButtonDownFcn', '');
 set(hdl.roottip, 'Value', 0);
 return
end

m=others.cimage;

pt=round(get(gca, 'CurrentPoint'));
dist=25;
roottip=0;
for i=1:img(m).npts,
 d=(img(m).ptsx(i)-pt(1,1))^2+(img(m).ptsy(i)-pt(1,2))^2;
 if d<dist,
  dist=d;
  roottip=i;
 end
end

if roottip>0
 if roottip>1 & roottip<img(m).npts,
     warndlg('Only the first or the last point can be root tip','Root tip alert');
     return
 end
 if roottip==img(m).npts,
     for i=2:length(img),
         if img(i).npts~=img(i-1).npts & img(i).npts>0,
             str=sprintf('Image %d has does not have same number of points as other images. Root tip cannot be marked.', i); 
             warndlg(str,'Uneven no. of points');
             return
             break
         end
     end
     for i=1:length(img),
         if img(i).npts>0,
             img(i).ptsx=img(i).ptsx(end:-1:1);
             img(i).ptsy=img(i).ptsy(end:-1:1);
             if img(i).edge_flag==1,
                 img(i).rootdia1x=img(i).rootdia1x(end:-1:1);
                 img(i).rootdia1x=img(i).rootdia1y(end:-1:1);
                 img(i).rootdia1x=img(i).rootdia2x(end:-1:1);
                 img(i).rootdia1x=img(i).rootdia2y(end:-1:1);
                 img(i).rootdia1x=img(i).cen_x(end:-1:1);
                 img(i).rootdia1x=img(i).cen_y(end:-1:1);
             end
         end
     end
 end
 others.roottip=1;
end
drawothers(m);

return

%====================================================

function ipolpts

global hdl img others;

m=others.cimage;

if img(m).npts<2,
    warndlg('You must select at least 2 point before interpolating','Interpolation alert');
    return
end

scatter=0;
% scatter=get(hdl.scatterpts,'value');
% if scatter==1,
%     if others.diaest<=0.0,
%       warndlg('For scattering points please provide an estimate of root diameter');
%       return
%     end
% end


if scatter==0,
    x=img(m).ptsx(1:img(m).npts);
    y=img(m).ptsy(1:img(m).npts);
    d=sqrt((x(2:end)-x(1:end-1)).^2+(y(2:end)-y(1:end-1)).^2);
    len=[0 cumsum(d)];
    len=len/len(end);
    n=round(str2num(get(hdl.ipolptsno,'string')));
    ii=(0:n-1)/(n-1);
    xx=spline(len,x,ii);
    yy=spline(len,y,ii);
    img(m).ptsx=xx;
    img(m).ptsy=yy;
    img(m).npts=length(img(m).ptsx);
    img(m).cc(1:img(m).npts)=0;
else
    x=img(m).picked_ptsx;
    y=img(m).picked_ptsy;
    i=(0:length(img(m).picked_ptsx)-1)/(length(img(m).picked_ptsx)-1);
    n=round(str2num(get(hdl.ipolptsno,'string')));
    ii=(0:n-1)/(n-1);
    xx=spline(i,x,ii);
    yy=spline(i,y,ii);
    xx1=xx;
    yy1=yy;
    for k=2:n-1,
        vy=(xx(k+1)-xx(k-1))/2;
        vx=-(yy(k+1)-yy(k-1))/2;
        v=sqrt(vx*vx+vy*vy);
        r=rand(1);
        s=1;
        if rand(1)<0.5,
            s=-1;
        end
        if v>0,
           vx=0.3*others.diaest*r*s*vx/v;
           vy=0.3*others.diaest*r*s*vy/v;
           xx1(k)=xx(k)+vx;
           yy1(k)=yy(k)+vy;
        end
    end
    img(m).ptsx=xx1;
    img(m).ptsy=yy1;
    img(m).npts=length(img(m).ptsx);
    img(m).cc(1:img(m).npts)=0;
end
drawothers(m);
if img(m).npts>25
    others.nseg=img(m).npts;
    others.intpts=img(m).npts;
end
return

%=====================================================

function scatterpts

global hdl others;

if get(hdl.scatterpts,'value')==1,
    set(hdl.show_pts,'value',[2]);
    others.pts_show=2;
end
return