function play_cb(action, varargin)

global hdl;

if nargin>=1,
feval(action,varargin{:});
end
return;

%=====================

function playfigure

global hdl img others;

nimages=length(img);
others.pauseflag=0;

n=others.cimage;
if n==nimages,
    n=1;
end

for i=n:nimages
    others.cimage=i;
    imagedraw(i);
    drawothers(i);
    if others.slowness > 0.01,
         pause(others.slowness);
    end
    if others.pauseflag==1
        break;
    end
end
    
return

%====================

function slowslider

global hdl others;

others.slowness=get(hdl.slowerslider,'value');
str=sprintf('%.0f%% slower', others.slowness*100);
set(hdl.slowertext,'string',str);

return

%====================

function playslider

global hdl img others;

others.cimage=round(get(hdl.playslider,'value'));

imagedraw(others.cimage); 
drawothers(others.cimage);

return

%===================

function pausemovie

global others;

others.pauseflag=1;

return

%==================

function savemovie

global hdl img others;

[filename, directory] =uiputfile('*.avi', ...
                                 'Select movie file');

if filename==0
    return
end

others.moviefile = sprintf('%s%s',directory, filename);

nimages=length(img);

n=others.cimage;
if n==nimages,
    n=1;
end

mov=avifile(others.moviefile,'Quality',100);

for i=n:nimages
    others.cimage=i;
    imagedraw(i);
    drawothers(i);
    if others.pauseflag==1
        break;
    end
    F = getframe(gca);
    mov = addframe(mov,F);
end

mov = close(mov);

return