function plotdata(action, varargin)

global hdl others;

others.x=[];
others.t=[];
others.p=[];

h=findobj(hdl.visualfig,'Tag','plot');
for i=1:length(h),
  str=get(h(i),'Label');
  str=sscanf(str,'%[^*]');
  set(h(i),'checked','off','Label',str);
end

h1=gcbo;
set(h1,'checked','on');
h2=get(h1,'parent');
if eq(h2,hdl.plot)==0,
    str=get(h2,'Label');
    str=sprintf('%s**',str);
    set(h2,'Label',str);
end

if nargin>=1,
 set(hdl.save,'enable','on');
 feval(action,varargin{:});
end

return;

%==========================

function growthchart

global hdl results others;

others.plotdata=1;
set(0,'currentfigure',hdl.visualfig);
axes(hdl.plotaxis);

for i=1:length(results),
    for j=1:length(results(i).cen_x)
        datax(i,j)=results(i).time;
        datay(i,j)=results(i).lc(j);
        j1=max(1,j-1);
        dataz(i,j)=results(i).lc(j)-results(i).lc(j1);
    end
end

h=mesh(datax,datay,dataz);
set(h,'EdgeColor',[0 0 1]);
view(2)

str=sprintf('Time (%s)',others.timeunit);
xlabel(str);

str=sprintf('Length from root tip along the centerline (%s)',others.matunit);
ylabel(str);

title('Root growth chart');
axis tight;
grid off;

others.plottype=1;
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','off');

return

%=============================

function growthrate_c_raw

global hdl results others;

others.plotdata=2;
n=length(results(1).lc);

for i=1:length(results),
 x(i,1:n)=results(i).lc;
end

cal_growthrate(x);

rawplot(others.x,others.t,others.p);

str=sprintf('Growth velocity (%s/%s)',others.matunit,others.timeunit);
ylabel(str);

title('Root growth velocity along the centerline');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on');

return

%=============================

function growthrate_c_mean

global hdl results others;

others.plotdata=5;
n=length(results(1).lc);

for i=1:length(results),
 x(i,1:n)=results(i).lc;
end

cal_growthrate(x);
meandata;
meanplot(others.binx,others.binp,others.binpsd);

str=sprintf('Mean growth velocity (%s/%s)',others.matunit,others.timeunit);
ylabel(str);

title('Root growth velocity along the centerline');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on');

return

%=============================

function growthrate_c_iso

global hdl results others;

others.plotdata=3;
n=length(results(1).lc);

for i=1:length(results),
 x(i,1:n)=results(i).lc;
end

cal_growthrate(x);

others.pmax=max(max(others.p));
others.pmin=min(min(others.p));
others.conts=others.pmin:((others.pmax-others.pmin)/others.conts_no):others.pmax;
contourplot(others.x,others.t,others.p);
str=sprintf('Root growth velocity along the centerline (%s/%s)',others.matunit,others.timeunit);
title(str);
set(hdl.contprop,'enable','on');
set(hdl.plotprop,'enable','on');

return

%=============================

function growthrate_c_ani

global hdl results others;

others.plotdata=4;
n=length(results(1).lc);

for i=1:length(results),
 x(i,1:n)=results(i).lc;
end

cal_growthrate(x);

ystr=sprintf('Growth velocity (%s/%s)',others.matunit,others.timeunit);
tstr='Root growth velocity along the centerline';
aniplot(others.x,others.t,others.p,ystr,tstr);

set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on');

return

%=============================

function growthrate_1_raw

global hdl results others;

others.plotdata=2;
n=length(results(1).l1);

for i=1:length(results),
 x(i,1:n)=results(i).l1;
end

cal_growthrate(x);

rawplot(others.x,others.t,others.p);

str=sprintf('Growth velocity (%s/%s)',others.matunit,others.timeunit);
ylabel(str);

title('Root growth velocity along edge 1 (green edge)');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on');

return

%=============================

function growthrate_1_mean

global hdl results others;

others.plotdata=5;
n=length(results(1).l1);

for i=1:length(results),
 x(i,1:n)=results(i).l1;
end

cal_growthrate(x);
meandata;
meanplot(others.binx,others.binp,others.binpsd);

str=sprintf('Mean growth velocity (%s/%s)',others.matunit,others.timeunit);
ylabel(str);

title('Root growth velocity along edge 1 (green edge)');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on');

return

%=============================

function growthrate_1_iso

global hdl results others;

others.plotdata=3;
n=length(results(1).l1);

for i=1:length(results),
 x(i,1:n)=results(i).l1;
end

cal_growthrate(x);

others.pmax=max(max(others.p));
others.pmin=min(min(others.p));
others.conts=others.pmin:((others.pmax-others.pmin)/others.conts_no):others.pmax;
contourplot(others.x,others.t,others.p);
str=sprintf('Root growth velocity along edge 1 (green edge)(%s/%s)',others.matunit,others.timeunit);
title(str);
set(hdl.contprop,'enable','on');
set(hdl.plotprop,'enable','on');

return

%=============================

function growthrate_1_ani

global hdl results others;

others.plotdata=4;
n=length(results(1).l1);

for i=1:length(results),
 x(i,1:n)=results(i).l1;
end

cal_growthrate(x);

ystr=sprintf('Growth velocity (%s/%s)',others.matunit,others.timeunit);
tstr='Root growth velocity along edge 1 (green edge)';

aniplot(others.x,others.t,others.p,ystr,tstr);

set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on');

return

%=============================

function growthrate_2_raw

global hdl results others;

others.plotdata=2;
n=length(results(1).l2);

for i=1:length(results),
 x(i,1:n)=results(i).l2;
end

cal_growthrate(x);

rawplot(others.x,others.t,others.p);

str=sprintf('Growth velocity (%s/%s)',others.matunit,others.timeunit);
ylabel(str);

title('Root growth velocity along edge 2 (yellow edge)');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on');

return

%=============================

function growthrate_2_mean

global hdl results others;

others.plotdata=5;
n=length(results(1).l2);

for i=1:length(results),
 x(i,1:n)=results(i).l2;
end

cal_growthrate(x);
meandata;
meanplot(others.binx,others.binp,others.binpsd);

str=sprintf('Mean growth velocity (%s/%s)',others.matunit,others.timeunit);
ylabel(str);

title('Root growth velocity along edge 2 (yeallow edge)');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on');

return

%=============================

function growthrate_2_iso

global hdl results others;

others.plotdata=3;
n=length(results(1).l2);

for i=1:length(results),
 x(i,1:n)=results(i).l2;
end

cal_growthrate(x);

others.pmax=max(max(others.p));
others.pmin=min(min(others.p));
others.conts=others.pmin:((others.pmax-others.pmin)/others.conts_no):others.pmax;
contourplot(others.x,others.t,others.p);

str=sprintf('Root growth velocity along edge 2 (yellow edge)(%s/%s)',others.matunit,others.timeunit);
title(str);
set(hdl.contprop,'enable','on');
set(hdl.plotprop,'enable','on');

return

%==========================
function growthrate_2_ani

global hdl results others;

others.plotdata=4;
n=length(results(1).l2);

for i=1:length(results),
 x(i,1:n)=results(i).l2;
end

cal_growthrate(x);

ystr=sprintf('Growth velocity (%s/%s)',others.matunit,others.timeunit);
tstr='Root growth velocity along edge 2 (yellow edge)';
aniplot(others.x,others.t,others.p,ystr,tstr);

set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on');

return

%=============================

function diameter_raw

global hdl results others;

others.plotdata=2;
n=length(results)-1;
m=length(results(1).lc);

for i=1:length(results),
 others.p(i,1:m)=results(i).dia;
 others.t(i,1:m)=results(i).time;
 others.x(i,1:m)=results(i).l2;
end

rawplot(others.x,others.t,others.p);

str=sprintf('Root diameter (%s)',others.matunit);
ylabel(str);

title('Root diameter');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on');

return

%=============================

function diameter_mean

global hdl results others;

others.plotdata=5;
n=length(results)-1;
m=length(results(1).lc);

for i=1:length(results),
 others.p(i,1:m)=results(i).dia;
 others.t(i,1:m)=results(i).time;
 others.x(i,1:m)=results(i).l2;
end

meandata;
meanplot(others.binx,others.binp,others.binpsd);

str=sprintf('Mean root diameter (%s)',others.matunit);
ylabel(str);

title('Root diameter');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on');

return

%=============================

function diameter_iso

global hdl results others;

others.plotdata=3;
n=length(results)-1;
m=length(results(1).lc);

for i=1:length(results),
 others.p(i,1:m)=results(i).dia;
 others.t(i,1:m)=results(i).time;
 others.x(i,1:m)=results(i).l2;
end

others.pmax=max(max(others.p));
others.pmin=min(min(others.p));
others.conts=others.pmin:((others.pmax-others.pmin)/others.conts_no):others.pmax;
contourplot(others.x,others.t,others.p);

str=sprintf('Root diameter (%s)',others.matunit);
title(str);
set(hdl.contprop,'enable','on');
set(hdl.plotprop,'enable','on');

return

%=============================

function diameter_ani

global hdl results others;

others.plotdata=4;
n=length(results)-1;
m=length(results(1).lc);

for i=1:length(results),
 others.p(i,1:m)=results(i).dia;
 others.t(i,1:m)=results(i).time;
 others.x(i,1:m)=results(i).l2;
end

ystr=sprintf('Root diameter (%s)',others.matunit);
tstr='Root diameter';
aniplot(others.x,others.t,others.p,ystr,tstr);

set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on');

return

%=============================

function relelong_c_raw

global hdl results others;


others.plotdata=2;
n=length(results(1).lc);

for i=1:length(results),
 x(i,1:n)=results(i).lc;
end

cal_relelong(x);

rawplot(others.x,others.t,others.p);

str=sprintf('Relative elongation rate (1/%s)',others.timeunit);
ylabel(str);

title('Relative elongation rate along the centerline');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on');

return

%=============================

function relelong_c_mean

global hdl results others;


others.plotdata=5;
n=length(results(1).lc);

for i=1:length(results),
 x(i,1:n)=results(i).lc;
end

cal_relelong(x);

meandata;
meanplot(others.binx,others.binp,others.binpsd);

str=sprintf('Mean relative elongation rate (1/%s)',others.timeunit);
ylabel(str);

title('Relative elongation rate along the centerline');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on');

return

%=============================

function relelong_c_iso

global hdl results others;

others.plotdata=3;
n=length(results(1).lc);

for i=1:length(results),
 x(i,1:n)=results(i).lc;
end

cal_relelong(x);

rawplot(others.x,others.t,others.p);

others.pmax=max(max(others.p));
others.pmin=min(min(others.p));
others.conts=others.pmin:((others.pmax-others.pmin)/others.conts_no):others.pmax;
contourplot(others.x,others.t,others.p);

str=sprintf('Relative elongation rate along the centerline(1/%s)',others.timeunit);
title(str);
set(hdl.contprop,'enable','on');
set(hdl.plotprop,'enable','on');

return

%=============================

function relelong_c_ani

global hdl results others;

others.plotdata=4;
n=length(results(1).lc);

for i=1:length(results),
 x(i,1:n)=results(i).lc;
end

cal_relelong(x);

rawplot(others.x,others.t,others.p);

ystr=sprintf('Relative elongation rate (1/%s)',others.timeunit);
tstr='Relative elongation rate along the centerline';

aniplot(others.x,others.t,others.p,ystr,tstr);

set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on');

return

%=============================

function relelong_1_raw

global hdl results others;

others.plotdata=2;
n=length(results(1).l1);

for i=1:length(results),
 x(i,1:n)=results(i).l1;
end

cal_relelong(x);

rawplot(others.x,others.t,others.p);

str=sprintf('Relative elongation rate (1/%s)',others.timeunit);
ylabel(str);

title('Relative elongation rate along the edge 1 (green edge)');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on')

return

%=============================

function relelong_1_mean

global hdl results others;

others.plotdata=5;
n=length(results(1).l1);

for i=1:length(results),
 x(i,1:n)=results(i).l1;
end

cal_relelong(x);

meandata;
meanplot(others.binx,others.binp,others.binpsd);

str=sprintf('Mean relative elongation rate (1/%s)',others.timeunit);
ylabel(str);

title('Relative elongation rate along the edge 1 (green edge)');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on')

return

%=============================

function relelong_1_iso

global hdl results others;

others.plotdata=3;
n=length(results(1).l1);

for i=1:length(results),
 x(i,1:n)=results(i).l1;
end

cal_relelong(x);

others.pmax=max(max(others.p));
others.pmin=min(min(others.p));
others.conts=others.pmin:((others.pmax-others.pmin)/others.conts_no):others.pmax;
contourplot(others.x,others.t,others.p);

str=sprintf('Relative elongation rate along the edge 1 (green edge)(1/%s)',others.timeunit);
title(str);
set(hdl.contprop,'enable','on');
set(hdl.plotprop,'enable','on')

return

%=============================

function relelong_1_ani

global hdl results others;

others.plotdata=4;
n=length(results(1).l1);

for i=1:length(results),
 x(i,1:n)=results(i).l1;
end

cal_relelong(x);

ystr=sprintf('Relative elongation rate (1/%s)',others.timeunit);
tstr='Relative elongation rate along the edge 1 (green edge)';
aniplot(others.x,others.t,others.p,ystr,tstr);
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on')

return

%=============================

function relelong_2_raw

global hdl results others;

others.plotdata=2;
n=length(results(1).l2);

for i=1:length(results),
 x(i,1:n)=results(i).l2;
end

cal_relelong(x);
rawplot(others.x,others.t,others.p);

str=sprintf('Relative elongation rate (1/%s)',others.timeunit);
ylabel(str);

title('Relative elongation rate along the edge 2 (yellow edge)');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on')

return

%=============================


function relelong_2_mean

global hdl results others;

others.plotdata=5;
n=length(results(1).l2);

for i=1:length(results),
 x(i,1:n)=results(i).l2;
end

cal_relelong(x);
meandata;
meanplot(others.binx,others.binp,others.binpsd);

str=sprintf('Mean relative elongation rate (1/%s)',others.timeunit);
ylabel(str);

title('Relative elongation rate along the edge 2 (yellow edge)');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on')

return

%=============================

function relelong_2_iso

global hdl results others;

others.plotdata=3;
n=length(results(1).l2);

for i=1:length(results),
 x(i,1:n)=results(i).l2;
end

cal_relelong(x);

others.pmax=max(max(others.p));
others.pmin=min(min(others.p));
others.conts=others.pmin:((others.pmax-others.pmin)/others.conts_no):others.pmax;
contourplot(others.x,others.t,others.p);


str=sprintf('Relative elongation rate along the edge 2 (yellow edge)(1/%s)',others.timeunit);
title(str);
set(hdl.contprop,'enable','on');
set(hdl.plotprop,'enable','on')

return

%=============================

function relelong_2_ani

global hdl results others;

others.plotdata=4;
n=length(results(1).l2);

for i=1:length(results),
 x(i,1:n)=results(i).l2;
end

cal_relelong(x);

ystr=sprintf('Relative elongation rate (1/%s)',others.timeunit);
tstr='Relative elongation rate along the edge 2 (yellow edge)';
aniplot(others.x,others.t,others.p,ystr,tstr);

set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on')

return

%=============================

function curvature_c_raw

global hdl results others;

others.plotdata=2;
n=length(results(1).lc);

for i=1:length(results),
 x(i,1:n)=results(i).cen_x;
 y(i,1:n)=results(i).cen_y;
 l(i,1:n)=results(i).lc;
end

cal_curvature(x,y,l);

rawplot(others.x,others.t,others.p);

str=sprintf('Root curvature (1/%s)',others.matunit);
ylabel(str);

title('Root curvature along the centerline');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on')

return

%=============================

function curvature_c_mean

global hdl results others;

others.plotdata=5;
n=length(results(1).lc);

for i=1:length(results),
 x(i,1:n)=results(i).cen_x;
 y(i,1:n)=results(i).cen_y;
 l(i,1:n)=results(i).lc;
end

cal_curvature(x,y,l);

meandata;
meanplot(others.binx,others.binp,others.binpsd);

str=sprintf('Mean root curvature (1/%s)',others.matunit);
ylabel(str);

title('Root curvature along the centerline');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on')

return

%=============================

function curvature_c_iso

global hdl results others;

others.plotdata=3;
n=length(results(1).lc);

for i=1:length(results),
 x(i,1:n)=results(i).cen_x;
 y(i,1:n)=results(i).cen_y;
 l(i,1:n)=results(i).lc;
end

cal_curvature(x,y,l);

others.pmax=max(max(others.p));
others.pmin=min(min(others.p));
others.conts=others.pmin:((others.pmax-others.pmin)/others.conts_no):others.pmax;
contourplot(others.x,others.t,others.p);

str=sprintf('Root curvature along the centerline(1/%s)',others.matunit);
title(str);
set(hdl.contprop,'enable','on');
set(hdl.plotprop,'enable','on')

return

%=============================

function curvature_c_ani

global hdl results others;

others.plotdata=4;
n=length(results(1).lc);

for i=1:length(results),
 x(i,1:n)=results(i).cen_x;
 y(i,1:n)=results(i).cen_y;
 l(i,1:n)=results(i).lc;
end

cal_curvature(x,y,l);
ystr=sprintf('Root curvature (1/%s)',others.matunit);
tstr='Root curvature along the centerline';
aniplot(others.x,others.t,others.p,ystr,tstr);
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on')

return

%=============================

function curvature_1_raw

global hdl results others;

others.plotdata=2;
n=length(results(1).l1);

for i=1:length(results),
 x(i,1:n)=results(i).dia1_x;
 y(i,1:n)=results(i).dia1_y;
 l(i,1:n)=results(i).l1;
end

cal_curvature(x,y,l);

rawplot(others.x,others.t,others.p);

str=sprintf('Root curvature (1/%s)',others.matunit);
ylabel(str);

title('Root curvature along edge 1 (green edge)');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on')

return

%=============================

function curvature_1_mean

global hdl results others;

others.plotdata=5;
n=length(results(1).l1);

for i=1:length(results),
 x(i,1:n)=results(i).dia1_x;
 y(i,1:n)=results(i).dia1_y;
 l(i,1:n)=results(i).l1;
end

cal_curvature(x,y,l);

meandata;
meanplot(others.binx,others.binp,others.binpsd);

str=sprintf('Mean root curvature (1/%s)',others.matunit);
ylabel(str);

title('Root curvature along edge 1 (green edge)');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on')

return

%=============================

function curvature_1_iso

global hdl results others;

others.plotdata=3;
n=length(results(1).l1);

for i=1:length(results),
 x(i,1:n)=results(i).dia1_x;
 y(i,1:n)=results(i).dia1_y;
 l(i,1:n)=results(i).l1;
end

cal_curvature(x,y,l);
others.pmax=max(max(others.p));
others.pmin=min(min(others.p));
others.conts=others.pmin:((others.pmax-others.pmin)/others.conts_no):others.pmax;
contourplot(others.x,others.t,others.p);

str=sprintf('Root curvature along edge 1 (green edge)(1/%s)',others.matunit);
title(str);
set(hdl.contprop,'enable','on');
set(hdl.plotprop,'enable','on')

return

%=============================

function curvature_1_ani

global hdl results others;

others.plotdata=4;
n=length(results(1).l1);

for i=1:length(results),
 x(i,1:n)=results(i).dia1_x;
 y(i,1:n)=results(i).dia1_y;
 l(i,1:n)=results(i).l1;
end

cal_curvature(x,y,l);

ystr=sprintf('Root curvature (1/%s)',others.matunit);
tstr='Root curvature along edge 1 (green edge)';
aniplot(others.x,others.t,others.p,ystr,tstr);

set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on')

return

%=============================

function curvature_2_raw

global hdl results others;

others.plotdata=2;
n=length(results(1).l2);

for i=1:length(results),
 x(i,1:n)=results(i).dia2_x;
 y(i,1:n)=results(i).dia2_y;
 l(i,1:n)=results(i).l2;
end

cal_curvature(x,y,l);

rawplot(others.x,others.t,others.p);

str=sprintf('Root curvature (1/%s)',others.matunit);
ylabel(str);

title('Root curvature along edge 2 (yellow edge)');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on')

return

%=============================

function curvature_2_mean

global hdl results others;

others.plotdata=5;
n=length(results(1).l2);

for i=1:length(results),
 x(i,1:n)=results(i).dia2_x;
 y(i,1:n)=results(i).dia2_y;
 l(i,1:n)=results(i).l2;
end

cal_curvature(x,y,l);

meandata;
meanplot(others.binx,others.binp,others.binpsd);

str=sprintf('Mean root curvature (1/%s)',others.matunit);
ylabel(str);

title('Root curvature along edge 2 (yellow edge)');
set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on')

return

%=============================

function curvature_2_iso

global hdl results others;

others.plotdata=3;
n=length(results(1).l2);

for i=1:length(results),
 x(i,1:n)=results(i).dia2_x;
 y(i,1:n)=results(i).dia2_y;
 l(i,1:n)=results(i).l2;
end

cal_curvature(x,y,l);

others.pmax=max(max(others.p));
others.pmin=min(min(others.p));
others.conts=others.pmin:((others.pmax-others.pmin)/others.conts_no):others.pmax;
contourplot(others.x,others.t,others.p);

str=sprintf('Root curvature along edge 2 (yellow edge)(1/%s)',others.matunit);
title(str);
set(hdl.contprop,'enable','on');
set(hdl.plotprop,'enable','on')

return

%=============================

function curvature_2_ani

global hdl results others;

others.plotdata=4;
n=length(results(1).l2);

for i=1:length(results),
 x(i,1:n)=results(i).dia2_x;
 y(i,1:n)=results(i).dia2_y;
 l(i,1:n)=results(i).l2;
end

cal_curvature(x,y,l);

ystr=sprintf('Root curvature (1/%s)',others.matunit);
tstr='Root curvature along edge 2 (yellow edge)';
aniplot(others.x,others.t,others.p,ystr,tstr);

set(hdl.contprop,'enable','off');
set(hdl.plotprop,'enable','on')

return


