function plotprop(action, varargin)

if nargin>=1,
 feval(action,varargin{:});
end

return;

function plotpropini

global hdl plw others;

figpos = get(hdl.figure, 'position');
bgcolor=[0.8 0.8 0.8];

ch=figpos(1)+figpos(3)/2;
cv=figpos(2)+figpos(4)/2;
figpos(1)=figpos(1)+50;
figpos(2)=cv-215;
figpos(3)=400;
figpos(4)=280;

plw.plotpropwin = figure( ...
   'Name','Data processing and statistics', ...
   'NumberTitle','off', 'HandleVisibility', 'on', ...
   'Visible','on', 'Color',bgcolor,...
   'BusyAction','Queue','Interruptible','on', ...
   'Color', [.8 .8 .8],'position',figpos);
set(plw.plotpropwin,'Resize','off');

pos(1)=30;
pos(2)=5;
pos(3)=145;
pos(4)=25;
plw.ok=uicontrol('Parent',plw.plotpropwin, 'Style','pushbutton', ...
   'Units','pixels', 'Position',pos, ...
   'String','Ok','Callback','plotprop(''ok'')');

pos(1)=pos(1)+pos(3)+30;
plw.cancel=uicontrol('Parent',plw.plotpropwin, 'Style','pushbutton', ...
   'Units','pixels', 'Position',pos, ...
   'String','cancel','Callback','plotprop(''cancel'')');


pos(2)=157;
pos(4)=22;
pos(1)=5;
pos(3)=350;
[spmax errmsg]=sprintf('Bins of X for calculating means (max X=%.2f,  min X=%.2f)',max(max(others.x)),min(min(others.x)));
uicontrol('Parent',plw.plotpropwin, 'Style','text','horiz','left', ...
   'Units','pixels', 'Position',pos,'Fontweight','bold', ...
   'String',spmax,'Background',[0.8 0.8 0.8],'Foreground',[0 0 0]);

pos(1)=5;
pos(2)=pos(4)+15;
pos(3)=150;
pos(4)=115;

others.tempplots=others.bin;
s='';
if size(others.tempplots) > 0
 n=size(others.tempplots);
 [s errmsg]=sprintf('%.2f',others.tempplots(1));
 for i=2:n(2)
  [s errmsg]=sprintf('%s|%.2f',s,others.tempplots(i));
 end
end
plw.list=uicontrol('Parent',plw.plotpropwin, 'Style','listbox', ...
   'Units','pixels', 'Position',pos,'String',s,'Max',1000,'Min',1);

pos(1)=pos(1)+pos(3)+5;
pos(3)=(figpos(3)-pos(1)-10)/2;
pos(4)=25;
pos1=pos;
pos1(4)=22;

pos(1)=pos(1)+pos(3)+5;
pos2=pos;
pos2(4)=22;

pos(1)=pos1(1);
pos(3)=figpos(3)-pos1(1)-5;
pos(4)=22;
plw.bins=uicontrol('Parent',plw.plotpropwin, 'Style','pushbutton', ...
   'Units','pixels','Position',pos, ...
   'String','Compute and add bins','Callback','plotprop(''computebin'')');


pos1(2)=pos(2)+22;
plw.increment=uicontrol('Parent',plw.plotpropwin, 'Style','radiobutton', ...
   'Units','pixels','Position',pos1, 'Value',1,...
   'String','Increment','Callback','plotprop(''incrementbin'')');

pos2(2)=pos(2)+22;
[s errmsg]=sprintf('%.2f',others.bindx);
plw.incrval=uicontrol('Parent',plw.plotpropwin, 'Style','edit', ...
   'Horiz','left',...
   'Units','pixels', 'Position',pos2,'String',s);


pos1(2)=pos1(2)+22;
plw.binno=uicontrol('Parent',plw.plotpropwin, 'Style','radiobutton', ...
   'Units','pixels', 'Position',pos1,'Value',0,...
   'String','No. of bins','Callback','plotprop(''binno'')');

pos2(2)=pos2(2)+22;
[s errmsg]=sprintf('%.f',others.binno);
plw.binval=uicontrol('Parent',plw.plotpropwin, 'Style','edit', ...
   'Horiz','left','Enable','Off',  ...
   'Units','pixels', 'Position',pos2,'String',s);


pos1(2)=pos1(2)+22;
uicontrol('Parent',plw.plotpropwin, 'Style','text', ...
   'Units','pixels', 'Position',pos1, ...
   'String','Minimum limit','Background',bgcolor,'Horiz','right');

pos2(2)=pos2(2)+22;
[s errmsg]=sprintf('%.2f',others.bin(1));
plw.minval=uicontrol('Parent',plw.plotpropwin, 'Style','edit', ...
   'Horiz','left', ...
   'Units','pixels', 'Position',pos2,'String',s);


pos1(2)=pos1(2)+22;
uicontrol('Parent',plw.plotpropwin, 'Style','text', ...
   'Units','pixels', 'Position',pos1, ...
   'String','Maximum limit','Background',bgcolor,'Horiz','right');

pos2(2)=pos2(2)+22;
[s errmsg]=sprintf('%.2f',others.bin(end));
plw.maxval=uicontrol('Parent',plw.plotpropwin, 'Style','edit', ...
   'Horiz','left', ...
   'Units','pixels', 'Position',pos2,'String',s);

pos(2)=192;
pos(4)=22;
pos(1)=5;
pos(3)=85;
uicontrol('Parent',plw.plotpropwin, 'Style','text','horiz','left', ...
   'Units','pixels', 'Position',pos, ...
   'String','Polynomial points','Background',[0.8 0.8 0.8],'Foreground',[0 0 .3]);

pos(1)=pos(1)+pos(3)+5;
pos(3)=35;
plw.poly_pts=uicontrol('Parent',plw.plotpropwin, 'Style','popupmenu','horiz','left', ...
   'Units','pixels', 'Position',pos,'value',others.sfac-1, ...
   'String','2|3|4|5|6|7|8|9|10');

pos(1)=pos(1)+pos(3)+5;
pos(3)=70;
uicontrol('Parent',plw.plotpropwin, 'Style','text','horiz','left', ...
   'Units','pixels', 'Position',pos, ...
   'String','Max iterations','Background',[0.8 0.8 0.8],'Foreground',[0 0 .3]);

pos(1)=pos(1)+pos(3)+5;
pos(3)=30;
plw.itermax=uicontrol('Parent',plw.plotpropwin, 'Style','edit','horiz','left', ...
   'Units','pixels', 'Position',pos,'string',num2str(others.itermax), ...
   'Background',[0.8 0.8 0.8],'Foreground',[0 0 .3]);


pos(1)=pos(1)+pos(3)+5;
pos(3)=110;
uicontrol('Parent',plw.plotpropwin, 'Style','text','horiz','left', ...
   'Units','pixels', 'Position',pos, ...
   'String','Convergence cirteria','Background',[0.8 0.8 0.8],'Foreground',[0 0 .3]);

pos(1)=pos(1)+pos(3)+5;
pos(3)=30;
plw.conv_crit=uicontrol('Parent',plw.plotpropwin, 'Style','edit','horiz','left', ...
   'Units','pixels', 'Position',pos,'string',num2str(others.conv_crit), ...
   'Background',[0.8 0.8 0.8],'Foreground',[0 0 .3]);

pos(1)=5;
pos(2)=214;
pos(3)=200;
uicontrol('Parent',plw.plotpropwin, 'Style','text','horiz','left', ...
   'Units','pixels', 'Position',pos,'Fontweight','bold', ...
   'String','Data smoothing parameters','Background',[0.8 0.8 0.8],'Foreground',[0 0 .3]);

pos(1)=5;
pos(2)=251;
pos(3)=120;
uicontrol('Parent',plw.plotpropwin, 'Style','text','horiz','left', ...
   'Units','pixels', 'Position',pos,'Fontweight','bold', ...
   'String','Spatial interpolation','Background',[0.8 0.8 0.8],'Foreground',[0 0 .3]);

pos(1)=pos(1)+pos(3)+5;
pos(3)=30;
plw.int_pts=uicontrol('Parent',plw.plotpropwin, 'Style','edit','horiz','left', ...
   'Units','pixels', 'Position',pos,'string',num2str(others.intpts), ...
   'Background',[0.8 0.8 0.8],'Foreground',[0 0 .3]);

pos(1)=pos(1)+pos(3)+5;
pos(3)=110;
uicontrol('Parent',plw.plotpropwin, 'Style','text','horiz','left', ...
   'Units','pixels', 'Position',pos, ...
   'String','points','Background',[0.8 0.8 0.8],'Foreground',[0 0 .3]);

return

%
%=========================
%

function ok

global plw others hdl;

n=length(others.tempplots)-1;
if n<1,
 warndlg('You must have the upper and lower bounds of at least 1 bin','Bin error');
 return
end

sfac=get(plw.poly_pts,'value')+1;
itermax=round(str2num(get(plw.itermax,'string')));
if itermax<1
 warndlg('Maximum number of iteriations > 0','Iteration no. error');
 return
end

conv_crit=str2num(get(plw.conv_crit,'string'));

intpts=round(str2num(get(plw.int_pts,'string')));
if itermax<1
 warndlg('No. of interpolation points > 12','Iteration no. error');
 return
end

others.bin=others.tempplots;
others.binno=n;
others.bindx=others.bin(2)-others.bin(1);
others.sfac=sfac;
others.itermax=itermax;
others.conv_crit=conv_crit;

if others.intpts~=intpts,
 quest=questdlg('To re-interpolate the plotting window must be closed.','Close plotting window?','Proceed','Ignore','Proceed'); 
 switch quest,
        case 'Proceed'
            others.intpts=intpts;
            close(hdl.visualfig);
            close(plw.plotpropwin);
        case 'Ignore'
            close(plw.plotpropwin);
            warndlg('Please replot to activate the changes','Replot');
 end
else
 close(plw.plotpropwin);  
 warndlg('Please replot to activate the changes','Replot');
end

return

%
%=========================
%

function cancel
global plw;
close(plw.plotpropwin);
return

function incrementbin
global plw;
v=get(plw.increment,'Value');
if v==1,
set(plw.incrval,'Enable','on');
set(plw.binval,'Enable','off');
set(plw.binno,'Value',0);
end
return

function binno
global plw;
v=get(plw.binno,'Value');
if v==1,
set(plw.incrval,'Enable','off');
set(plw.binval,'Enable','on');
set(plw.increment,'Value',0);
end
return

function computebin

global plw others;

lmax=str2num(get(plw.maxval,'String'));
lmin=str2num(get(plw.minval,'String'));

if lmax<lmin
 warning('Maximum bin must be greater than minimum bin');
 return
end

v=get(plw.binno,'Value');
if v==1
 n=round(str2num(get(plw.binval,'String')));
 if n == 1
  temp=(lmin+lmax)/2;
  delta=0.0;
 elseif n == 2
  temp=[lmin lmax];
  delta=lmax-lmin;
 elseif n > 2
  delta=(lmax-lmin)/(n-1);
  temp=lmin:delta:lmax;
 else
  return;
 end
else
 delta=str2num(get(plw.incrval,'String'));
 temp=lmin:delta:lmax;
end

others.tempplots=temp;
s='';
if length(others.tempplots) > 0
 n=length(others.tempplots);
 [s errmsg]=sprintf('%.2f',others.tempplots(1));
 for i=2:n
  [s errmsg]=sprintf('%s|%.2f',s,others.tempplots(i));
 end
end

set(plw.list,'String',s);
set(plw.binval,'String',num2str(n));
set(plw.incrval,'String',num2str(delta));

return

