function read_results

global hdl img others;

[filename,dir]=uigetfile('*.txt','Read measurements from');

if filename==0
    return
end

filename=sprintf('%s\\%s',dir,filename);
data=load(filename);

n=round(data(1,5));
if n<1,
    warndlg('Empty result file. Results not read.','Data read error');
    return
end

if n>length(img),
    quest=questdlg('You have probably selected the wrong file. Do you want to continue reading?','Read results','Yes','No','No');
    switch quest,
        case 'Yes'
            n=length(img);
        case 'No'
            return
    end
    
end

others.period=data(1,1);
others.periodunit=round(data(1,2));
others.scale=data(1,3);
others.unitvalue=round(data(1,4));
others.roottip=round(data(1,6));
others.diaest=data(1,7);
mmax=round(data(1,8));

for i=1:n,
    k=data(i+1,1);
    img(k).npts=round(data(i+1,2));
    m=img(k).npts;
    ncs=round(data(i+1,3));
    if m>0
        img(k).ptsx(1:m)=data(i+1,     4:     m+3);
        img(k).ptsy(1:m)=data(i+1,mmax+4:mmax+m+3);
        img(k).edge_flag=round(data(i+1,2*mmax+4));
        if img(k).edge_flag==1,
            img(k).rootdia1x(1:ncs)=data(i+1,2*mmax+5:2*mmax+ncs+4);
            img(k).rootdia1y(1:ncs)=data(i+1,3*mmax+5:3*mmax+ncs+4);
            img(k).rootdia2x(1:ncs)=data(i+1,4*mmax+5:4*mmax+ncs+4);
            img(k).rootdia2y(1:ncs)=data(i+1,5*mmax+5:5*mmax+ncs+4);
            img(k).cen_x(1:ncs)=data(i+1,6*mmax+5:6*mmax+ncs+4);
            img(k).cen_y(1:ncs)=data(i+1,7*mmax+5:7*mmax+ncs+4);
        end
        img(k).cc(1:m)=data(i+1,8*mmax+5:8*mmax+m+4);
    end
end

switch others.unitvalue
        case 1
            others.unit='cm';
        case 2
            others.unit='mm';
        case 3
            others.unit='in';
        case 4
            others.unit='px';
        case 5
            others.unit='um';
            others.matunit='\mum';
end

str=sprintf('Scale Info:\n %.2f px = 1 %s',others.scale,others.unit);

set(hdl.scaleheading,'string',str);
set(hdl.spixel,'string',num2str(others.scale));
set(hdl.scale,'value',1);
set(hdl.sunit,'value',others.unitvalue);
set(hdl.period,'string',num2str(others.period));
set(hdl.periodunit,'value',others.periodunit);
%scaleok;
if img(1).npts>25
    others.nseg=img(1).npts;
    others.intpts=img(1).npts;
end
imagedraw(others.cimage);
drawothers(others.cimage);

return