function scale_buttons

global hdl img others;

pos=get(hdl.slowerslider,'position');
gap=0.005;
width=pos(4);;
pos(1)=pos(1)+pos(3)+gap;
pos(3)=0.09;
fpos=pos;

hdl.scaleframe=uicontrol(hdl.figure,'Style','Frame','Units','normalized', ...
    'Position',[0.51,0.0,0.295,0.097],'background',[0.3,0,0.3],'Tag','scale');

str=sprintf('Scale Info:\n%.2f px = 1 %s',others.scale,others.unit);
hdl.scaleheading=uicontrol(hdl.figure,'Style','text','Units','normalized', ...
    'Position',pos,'string',str,'background',[0.3,0,0.3],'foreground',[1 1 0],'Tag','scale');

pos(1)=pos(1)+pos(3)+0.005;
hdl.smeasure=uicontrol(hdl.figure,'Style','radiobutton','Units','normalized', ...
    'Position',pos,'string','Measure', ...
    'callback','scale_image(''measure'')','Tag','clickndraw');

pos(1)=pos(1)+pos(3)+0.005;
hdl.periodtext=uicontrol(hdl.figure,'Style','text','Units','normalized', ...
    'Position',pos,'string','Time period','background',[0.3,0,0.3],'foreground',[0 1 1]);

pos(2)=pos(2)-width-gap;
pos(1)=fpos(1);
pos(3)=0.03;
hdl.spixel=uicontrol(hdl.figure,'Style','Edit','Units','normalized', ...
    'Position',pos,'string',num2str(others.scale),'background',[0.3,0,0.3],'foreground',[1 1 0],'Tag','scale');

pos(1)=pos(1)+pos(3);
pos(3)=0.04;
hdl.spixeltext=uicontrol(hdl.figure,'Style','Text','Units','normalized', ...
    'Position',pos,'string','pixels = ','background',[0.3,0,0.3],'foreground',[1 1 0],'Tag','scale');


pos(1)=pos(1)+pos(3);
pos(3)=0.035;
hdl.scale=uicontrol(hdl.figure,'Style','Edit','Units','normalized', ...
    'Position',pos,'string','1', ...
    'background',[0.3,0,0.3],'foreground',[1 1 0],'Tag','scale');

pos(1)=pos(1)+pos(3)+gap;
pos(3)=0.04;
hdl.sunit=uicontrol(hdl.figure,'Style','popupmenu','Units','normalized','value',others.unitvalue, ...
    'Position',pos,'string','cm|mm|in|px|um','background',[0.3,0,0.3],'foreground',[1 1 0],'Tag','scale');

pos(1)=pos(1)+pos(3)+gap;
pos(3)=0.03;
hdl.scaleok=uicontrol(hdl.figure,'Style','pushbutton','Units','normalized', ...
    'Position',pos,'string','Ok','fontweight','bold','foreground',[0.5,0,0.5], ...
    'callback','scaleok','Tag','scale','background',[1 1 0]);

pos(1)=pos(1)+pos(3)+gap;
pos(3)=0.035;
hdl.period=uicontrol(hdl.figure,'Style','Edit','Units','normalized', ...
    'Position',pos,'string',num2str(others.period), ...
    'Tag','scale','background',[0.3,0,0.3],'foreground',[0 1 1]);

pos(1)=pos(1)+pos(3)+gap;
pos(3)=0.055;
hdl.periodunit=uicontrol(hdl.figure,'Style','Popupmenu','Units','normalized', ...
    'Position',pos,'string','ms|sec|min|hour|day|week', ...
    'Tag','scale','value',others.periodunit,'background',[0.3,0,0.3],'foreground',[0 1 1]);

return