function scale_image(action, varargin)

global hdl;
%exclusive radio buttons
h1=gcbo;
if strncmpi(get(h1,'Type'),'uicontrol',4)==1,
 if strncmpi(get(h1,'Style'),'radiobutton',4)==1,
    h=findobj(hdl.figure,'style','radiobutton','Tag','clickndraw');
    for i=1:length(h),
     if eq(h(i),h1)==0 & eq(h(i),hdl.trackdirectional)==0,
       set(h(i),'value',0);
     end
    end
%     zoom off;
%     set(hdl.zoom,'value',[0],'Foreground',[0 0 0]);
 end
end

if nargin>=1,
 feval(action,varargin{:});
end

return;

%
%================
%

function measure

global hdl;

if hdl.scaleline > 0.0,
    delete(hdl.scaleline);
    hdl.scaleline=-1;
end
mes_flag=get(hdl.smeasure,'Value');
if mes_flag==1
 set(hdl.figure, 'WindowButtonDownFcn', 'scale_image(''ButtonDownOnMano'')');
else
 return;
end

return

%
%================
%

function ButtonDownOnMano

global hdl others;

pt = get(gca, 'CurrentPoint');
others.scalex0 = pt(1,1); 
others.scaley0 = pt(1,2); 
others.scalex1 = others.scalex0;
others.scaley1 = others.scaley0;
hdl.scaleline=line([others.scalex1 others.scalex0],[others.scaley1 others.scaley0],'erasemode', 'xor');
set(hdl.figure, 'WindowButtonMotionFcn', 'scale_image(''DrawLine'')');
set(hdl.figure, 'WindowButtonUpFcn', 'scale_image(''BackToNormalcy'')');

return


function DrawLine

global hdl others;

 if hdl.scaleline>0.0
  delete(hdl.scaleline);
 end

 pt = get(gca, 'CurrentPoint');
 others.scalex1 = pt(1,1);
 others.scaley1 = pt(1,2);
 hdl.scaleline=line([others.scalex1 others.scalex0],[others.scaley1 others.scaley0],'erasemode', 'xor');
return

%%%
%%%  Sub-function - BackToNormalcy
%%%

function BackToNormalcy

global others hdl;

%if hdl.scaleline >0.0
% delete(hdl.scaleline);
% hdl.scaleline=-1;
%end

set(hdl.figure, 'WindowButtonDownFcn', '');
set(hdl.figure, 'WindowButtonMotionFcn', '');
set(hdl.figure, 'WindowButtonUpFcn', '');
set(hdl.smeasure,'Value',0);

dist=sqrt((others.scalex1-others.scalex0)^2+(others.scaley1-others.scaley0)^2);

str=sprintf('%.0f',dist);
set(hdl.spixel,'string',str);

return