function track_cb(action, varargin)

global hdl;

if nargin>=1,
feval(action,varargin{:});
end
return

%=====================================

function trackpts

global hdl img others;

m=others.cimage;
n=img(m).npts;

nimg=length(img);
srad=round(str2num(get(hdl.trackrad,'string')));
ptrad=round(str2num(get(hdl.tracktemplate,'string')));

h=mywaitbar(0,'Tracking points');
npt=(nimg-1)*n;
k=0;
cmin(m)=1;
for i=m-1:-1:1,
    for j=1:n,
        img(i).cc(j)=track_a_pt(i+1,i,j,m,ptrad,srad);
        k=k+1;
        mywaitbar(k/npt);
    end
    cmin(i)=min(img(i).cc);
end
for i=m+1:1:length(img),
    for j=1:n,
        img(i).cc(j)=track_a_pt(i-1,i,j,m,ptrad,srad);
        k=k+1;
        mywaitbar(k/npt);
    end
    cmin(i)=min(img(i).cc);
end
close(h);

if others.midline==1,
    findmidline;
    drawothers(m);
end

% s=sprintf('.                         Confidence level %.1f%%                             .',100*min(cmin));
% msgbox(s,'Tracking confidence');

return

%================================

function trackcheck

global hdl others img;

if img(1).npts<=0,
    warndlg('Track points first','Root points alert');
    return
end
if others.roottip<=0,
    warndlg('Select root tip','Root tip alert');
    return
end
for i=2:length(img),
    if img(i).npts~=img(i-1).npts & img(i).npts>0,
        str=sprintf('Image %d has does not have same number of points as other images. Checking cannot be done.', i);
        warndlg(str,'Uneven no. of points');
        return
        break
    end
end

ccmax=max(img(1).cc);
m=1;
if ccmax<1,
    for i=2:length(img),
        cmax=max(img(i).cc);
        if cmax>=1,
            m=i;
            break;
        end
        if cmax>ccmax,
            m=i;
            ccmax=cmax;
        end
    end
end

for i=m-1:-1:1,
    n=img(i).npts;
    vx=img(i+1).ptsx-img(i).ptsx;
    vy=img(i+1).ptsy-img(i).ptsy;
    v=sqrt(vx.^2+vy.^2);
    
    if img(i).cc(1)>=img(i).cc(n)
        for j=2:n,
            if v(j)>v(j-1) & v(j)>0,
                img(i).ptsx(j)=img(i+1).ptsx(j)-vx(j)*v(j-1)/v(j);
                img(i).ptsy(j)=img(i+1).ptsy(j)-vy(j)*v(j-1)/v(j);
            end
        end
    else
        for j=1:n-1,
            if v(j+1)>v(j) & v(j)>0,
                img(i).ptsx(j)=img(i+1).ptsx(j)-vx(j)*v(j+1)/v(j);
                img(i).ptsy(j)=img(i+1).ptsy(j)-vy(j)*v(j+1)/v(j);
            end
        end
    end
end

for i=m+1:length(img),
    n=img(i).npts;
    vx=img(i).ptsx-img(i-1).ptsx;
    vy=img(i).ptsy-img(i-1).ptsy;
    v=sqrt(vx.^2+vy.^2);
    
    if img(i).cc(1)>=img(i).cc(n)
        for j=2:n,
            if v(j)>v(j-1) & v(j)>0,
                img(i).ptsx(j)=img(i-1).ptsx(j)+vx(j)*v(j-1)/v(j);
                img(i).ptsy(j)=img(i-1).ptsy(j)+vy(j)*v(j-1)/v(j);
            end
        end
    else
        for j=1:n-1,
            if v(j+1)>v(j) & v(j)>0,
                img(i).ptsx(j)=img(i-1).ptsx(j)+vx(j)*v(j+1)/v(j);
                img(i).ptsy(j)=img(i-1).ptsy(j)+vy(j)*v(j+1)/v(j);
            end
        end
    end
end



return