function LocalMax = FLocMax(dir,ix,iy,mag)

[m,n] = size(mag);

switch dir
 case 1
  id = find((iy<=0 & ix>-iy)  | (iy>=0 & ix<-iy));
 case 2
  id = find((ix>0 & -iy>=ix)  | (ix<0 & -iy<=ix));
 case 3
  id = find((ix<=0 & ix>iy) | (ix>=0 & ix<iy));
 case 4
  id = find((iy<0 & ix<=iy) | (iy>0 & ix>=iy));
end

if ~isempty(id)
  v = mod(id,m);
  extId = find(v==1 | v==0 | id<=m | (id>(n-1)*m));
  id(extId) = [];
end

gradmag = mag(id);
iyv = iy(id); 
ixv = ix(id);  
  
switch dir
 case 1
  d = abs(iyv./ixv);
  gradmag2 = mag(id-m).*(1-d) + mag(id-m+1).*d; 
  gradmag1 = mag(id+m).*(1-d) + mag(id+m-1).*d; 
  
 case 2
  d = abs(ixv./iyv);
  gradmag1 = mag(id-1).*(1-d) + mag(id+m-1).*d; 
  gradmag2 = mag(id+1).*(1-d) + mag(id-m+1).*d; 
 case 3
  d = abs(ixv./iyv);
  gradmag2 = mag(id+1).*(1-d) + mag(id+m+1).*d; 
  gradmag1 = mag(id-1).*(1-d) + mag(id-m-1).*d; 
  
 case 4
  d = abs(iyv./ixv);
  gradmag2 = mag(id+m).*(1-d) + mag(id+m+1).*d; 
  gradmag1 = mag(id-m).*(1-d) + mag(id-m-1).*d; 
  
end
LocalMax = id(gradmag>=gradmag1 & gradmag>=gradmag2); 

