function channelimagedraw(n,c)

global img hdl others;


set(0,'currentfigure',hdl.figure);
axes(hdl.axis);

a=axis;
if c==4,
    imagesc(mean(single(img(n).image),3));
else
    imagesc(img(n).image(:,:,c));
end
colormap gray;
axis equal
if a~=[0 1 0 1],
    axis(a);
end

axis off

switch c,
    case 1
        cc='red channel';
    case 2
        cc='green channel';
    case 3
        cc='blue channel';
    case 4
        cc='grayscale';
end

str = sprintf('Image No. %d (time=%.1f %s): %s -- %s', ...
               n, img(n).time, others.timeunit, img(n).filename,cc);
title(texlabel(str, 'literal'));

set(hdl.playslider,'value',n);
% drawnow;

hdl.pts=-1;
hdl.roottippt=-1;
hdl.scaleline=-1;
hdl.diaestline=-1;
hdl.outline=-1;
hdl.centerline=-1;

return