function contprop(action, varargin)

if nargin>=1,
 feval(action,varargin{:});
end

return

function contpropini

global hdl clw others;

figpos = get(hdl.figure, 'position');
bgcolor=[0.8 0.8 0.8];

ch=figpos(1)+figpos(3)/2;
cv=figpos(2)+figpos(4)/2;
figpos(1)=figpos(1)+50;
figpos(2)=cv-215;
figpos(3)=400;
figpos(4)=250;

clw.contpropwin = figure( ...
   'Name','Contour levels', ...
   'NumberTitle','off', 'HandleVisibility', 'on', ...
   'Visible','on', 'Color',bgcolor,...
   'BusyAction','Queue','Interruptible','on', ...
   'Color', [.8 .8 .8],'position',figpos);
set(clw.contpropwin,'Resize','off');

pos(1)=30;
pos(2)=5;
pos(3)=145;
pos(4)=25;
clw.ok=uicontrol('Parent',clw.contpropwin, 'Style','pushbutton', ...
   'Units','pixels', 'Position',pos, ...
   'String','Ok','Callback','contprop(''ok'')');

pos(1)=pos(1)+pos(3)+30;
clw.cancel=uicontrol('Parent',clw.contpropwin, 'Style','pushbutton', ...
   'Units','pixels', 'Position',pos, ...
   'String','cancel','Callback','contprop(''cancel'')');

pos(1)=270;
pos(3)=63;
pos(2)=222;
pos(4)=22;
uicontrol('Parent',clw.contpropwin,'Style','text', ...
   'Units','Pixels','Position',pos, ...
   'String','Colormap','Background',[0.8 0.8 0.8]);

pos(1)=330;
clw.colmap=uicontrol('Parent',clw.contpropwin,'Style','popupmenu', ...
   'Units','Pixels','Position',pos, ...
   'String','Bone|Cool|Copper|Flag|Gray|Hot|HSV|Jet|Pink|Prism', ...
   'Value',others.cmap,'Callback','contprop(''colormapselect'')');

pos(1)=5;
pos(3)=250;
[spmax errmsg]=sprintf('Maximum value: %.2f   Minimum value: %.2f',others.pmax,others.pmin);
uicontrol('Parent',clw.contpropwin, 'Style','text','horiz','left', ...
   'Units','pixels', 'Position',pos,'Fontweight','bold', ...
   'String',spmax,'Background',[0.8 0.8 0.8],'Foreground',[0 0 0]);

pos(1)=5;
pos(2)=35;
pos(3)=150;
pos(4)=25;

clw.remove=uicontrol('Parent',clw.contpropwin, 'Style','pushbutton', ...
   'Units','pixels', 'Position',pos, ...
   'String','Remove levels','Callback','contprop(''dellevel'')');

pos(1)=pos(1)+pos(3)+5;
pos(3)=figpos(3)-pos(1)-5;
clw.addbtn=uicontrol('Parent',clw.contpropwin, 'Style','pushbutton', ...
   'Units','pixels', 'Position',pos, ...
   'String','Add contours with mouse','Callback','contprop(''mcontadd'')');

pos(1)=5;
pos(2)=pos(2)+pos(4)+5;
pos(3)=150;
pos(4)=150;

others.tempconts=others.conts;
s='';
if size(others.tempconts) > 0
 n=size(others.tempconts);
 [s errmsg]=sprintf('%f',others.tempconts(1));
 for i=2:n(2)
  [s errmsg]=sprintf('%s|%f',s,others.tempconts(i));
 end
end
clw.list=uicontrol('Parent',clw.contpropwin, 'Style','listbox', ...
   'Units','pixels', 'Position',pos,'String',s,'Max',1000,'Min',1);

pos(1)=pos(1)+pos(3)+5;
pos(3)=(figpos(3)-pos(1)-10)/2;
pos(4)=25;
pos1=pos;
pos1(4)=22;
clw.addbtn=uicontrol('Parent',clw.contpropwin, 'Style','pushbutton', ...
   'Units','pixels', 'Position',pos, ...
   'String','<< Add level','Callback','contprop(''addlevel'')');

pos(1)=pos(1)+pos(3)+5;
pos2=pos;
pos2(4)=22;
clw.addlevel=uicontrol('Parent',clw.contpropwin, 'Style','edit', ...
   'Horiz','left', ...
   'Units','pixels', 'Position',pos, ...
   'String','');

pos(1)=pos1(1);
pos(2)=pos(2)+pos(4)+15;
pos(3)=figpos(3)-pos1(1)-5;
pos(4)=22;
clw.levels=uicontrol('Parent',clw.contpropwin, 'Style','pushbutton', ...
   'Units','pixels','Position',pos, ...
   'String','Compute and add levels','Callback','contprop(''compute'')');


pos1(2)=pos(2)+22;
clw.increment=uicontrol('Parent',clw.contpropwin, 'Style','radiobutton', ...
   'Units','pixels','Position',pos1, ...
   'String','Increment','Callback','contprop(''increment'')');

pos2(2)=pos(2)+22;
[s errmsg]=sprintf('%f',others.conts_del);
clw.incrval=uicontrol('Parent',clw.contpropwin, 'Style','edit', ...
   'Horiz','left','Enable','Off', ...
   'Units','pixels', 'Position',pos2,'String',s);


pos1(2)=pos1(2)+22;
clw.levelno=uicontrol('Parent',clw.contpropwin, 'Style','radiobutton', ...
   'Units','pixels', 'Position',pos1,'Value',1,...
   'String','No. of levels','Callback','contprop(''levelno'')');

pos2(2)=pos2(2)+22;
[s errmsg]=sprintf('%.f',others.conts_no);
clw.levelval=uicontrol('Parent',clw.contpropwin, 'Style','edit', ...
   'Horiz','left', ...
   'Units','pixels', 'Position',pos2,'String',s);


pos1(2)=pos1(2)+22;
uicontrol('Parent',clw.contpropwin, 'Style','text', ...
   'Units','pixels', 'Position',pos1, ...
   'String','Minimum limit','Background',bgcolor,'Horiz','right');

pos2(2)=pos2(2)+22;
[s errmsg]=sprintf('%.4f',others.pmin);
clw.minval=uicontrol('Parent',clw.contpropwin, 'Style','edit', ...
   'Horiz','left', ...
   'Units','pixels', 'Position',pos2,'String',s);


pos1(2)=pos1(2)+22;
uicontrol('Parent',clw.contpropwin, 'Style','text', ...
   'Units','pixels', 'Position',pos1, ...
   'String','Maximum limit','Background',bgcolor,'Horiz','right');

pos2(2)=pos2(2)+22;
[s errmsg]=sprintf('%.4f',others.pmax);
clw.maxval=uicontrol('Parent',clw.contpropwin, 'Style','edit', ...
   'Horiz','left', ...
   'Units','pixels', 'Position',pos2,'String',s);

% figure(hdl.figure);

return

%
%=========================
%

function ok

global clw others;

others.conts=others.tempconts;

n=size(others.tempconts);
others.conts_no=n(2);
if n(2)<=1,
 others.conts_del=0.0;
else
 others.conts_del=others.tempconts(2)-others.tempconts(1);
end

close(clw.contpropwin);
contourplot(others.contsx,others.contst,others.contsp);

return

%
%=========================
%

function cancel
global clw;
close(clw.contpropwin);
return

%
%=========================
%

function dellevel
global clw others;
v=get(clw.list,'value');
n=size(others.tempconts);

temp=[others.tempconts(1:v(1)-1) others.tempconts(v(end)+1:n(2))];
others.tempconts=temp;

s='';
if size(others.tempconts) > 0
 n=size(others.tempconts);
 [s errmsg]=sprintf('%f',others.tempconts(1));
 for i=2:n(2)
  [s errmsg]=sprintf('%s|%f',s,others.tempconts(i));
 end
end

val=v(1);
n=size(others.tempconts);
if val>n(2)
 val=n(2);
end
if val==0
 val=1;
end

set(clw.list,'Value',val);
set(clw.list,'String',s);

return

function addlevel
global clw others;
s=get(clw.addlevel,'String');
v=str2num(s);
temp=others.tempconts;
temp(end+1)=v;
others.tempconts=sort(temp);

s='';
if size(others.tempconts) > 0
 n=size(others.tempconts);
 [s errmsg]=sprintf('%f',others.tempconts(1));
 for i=2:n(2)
  [s errmsg]=sprintf('%s|%f',s,others.tempconts(i));
 end
end
set(clw.list,'String',s);
return

function increment
global clw;
v=get(clw.increment,'Value');
if v==1,
set(clw.incrval,'Enable','on');
set(clw.levelval,'Enable','off');
set(clw.levelno,'Value',0);
end
return

function levelno
global clw;
v=get(clw.levelno,'Value');
if v==1,
set(clw.incrval,'Enable','off');
set(clw.levelval,'Enable','on');
set(clw.increment,'Value',0);
end
return

function compute

global clw others;

lmax=str2num(get(clw.maxval,'String'));
lmin=str2num(get(clw.minval,'String'));

if lmax<lmin
 warning('Maximum level must be greater than minimum level');
 return
end

v=get(clw.levelno,'Value');
if v==1
 n=round(str2num(get(clw.levelval,'String')));
 if n == 1
  temp=(lmin+lmax)/2;
  delta=0.0;
 elseif n == 2
  temp=[lmin lmax];
  delta=lmax-lmin;
 elseif n > 2
  delta=(lmax-lmin)/(n-1);
  temp=lmin:delta:lmax;
 else
  return;
 end
else
 delta=str2num(get(clw.incrval,'String'));
 temp=lmin:delta:lmax;
end

others.tempconts=sort([others.tempconts temp]);

s='';
if size(others.tempconts) > 0
 n=size(others.tempconts);
 [s errmsg]=sprintf('%f',others.tempconts(1));
 for i=2:n(2)
  [s errmsg]=sprintf('%s|%f',s,others.tempconts(i));
 end
end

set(clw.list,'String',s);
set(clw.levelval,'String',num2str(n(2)));
set(clw.incrval,'String',num2str(delta));

return


function mcontadd

global xtp clw hdl others;

figure(hdl.visualfig);
xy=ginput(1);
figure(clw.contpropwin);

ti=xy(:,1);
xi=xy(:,2);

val=griddata(others.t,others.x,others.p,ti,xi);

others.tempconts=sort([others.tempconts val]);
s='';
if size(others.tempconts) > 0
 n=size(others.tempconts);
 [s errmsg]=sprintf('%f',others.tempconts(1));
 for i=2:n(2)
  [s errmsg]=sprintf('%s|%f',s,others.tempconts(i));
 end
end
set(clw.list,'String',s);

return;


function colormapselect
global clw hdl others;

others.cmap=get(clw.colmap,'value');

switch others.cmap
case 1
   colmap=bone;
case 2
   colmap=cool;
case 3
   colmap=copper;
case 4
   colmap=flag;
case 5
   colmap=gray;
case 6
   colmap=hot;
case 7
   colmap=hsv;
case 8
   colmap=jet;
case 9
   colmap=pink;
case 10
   colmap=prism;
otherwise
   colmap=gray;
end   

set(0,'currentfigure',hdl.visualfig);
colormap(colmap);

return
