function createanalysisbuttons

global hdl img others;

pos=get(hdl.axis,'position');
gap=0.003;
pos(1)=pos(1)+pos(3)+gap;
pos(3)=1-pos(1)-gap;
pos(4)=0.033;
pos(2)=1-gap-pos(4);


fpos=pos;
fpos(4)=fpos(4)*3+5*gap;
fpos(2)=1-fpos(4);
hdl.ptsframe=uicontrol(hdl.figure,'Style','Frame', ...
    'Units','normalized','Background',[.2 0 0],...
    'Position',fpos,'Tag','points');

pos(1)=pos(1)+gap;
pos(3)=pos(3)-2*gap;
pos(2)=pos(2)-gap;
hdl.pickpts=uicontrol(hdl.figure,'Style','radiobutton','Tag','clickndraw', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[0.5 0 0],...
    'Position',pos,'string','Pick pts','callback','pickpts_cb(''pickpts'')');

hpos=pos;
hpos(3)=(hpos(3)-gap)/2;
hpos(1)=hpos(1)+hpos(3)+gap;
hdl.movepts=uicontrol(hdl.figure,'Style','radiobutton','Tag','clickndraw', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[0.5 0 0],...
    'Position',hpos,'string','Move pts','callback','pickpts_cb(''movepts'')');

pos(2)=pos(2)-pos(4)-gap;
hpos=pos;
hpos(3)=(hpos(3)-gap)*0.5;
hdl.ipolpts=uicontrol(hdl.figure,'Style','pushbutton','Tag','clickndraw', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[0.5 0 0],...
    'Position',hpos,'string','Interpolate','callback','pickpts_cb(''ipolpts'')');


hpos(1)=hpos(1)+hpos(3)+gap;
hpos(3)=(pos(3)-gap)*0.5;
hdl.ipolptsno=uicontrol(hdl.figure,'Style','Edit','Tag','clickndraw', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[0.5 0 0],...
    'Position',hpos,'string','25');

% 
% hpos(1)=hpos(1)+hpos(3)+gap;
% hpos(3)=(pos(3)-gap)*0.4;
% hdl.scatterpts=uicontrol(hdl.figure,'Style','radiobutton', ...
%     'Units','normalized','FontWeight','Bold', 'Foreground',[0.5 0 0],...
%     'Position',hpos,'string','Scatter','value',0,'callback','pickpts_cb(''scatterpts'')');

% hpos=pos;
% hpos(3)=(hpos(3)-2*gap)/3;
% hpos(2)=hpos(2)-hpos(4)-gap;
% pos(2)=hpos(2);
% hdl.optimizepts=uicontrol(hdl.figure,'Style','pushbutton','Tag','points', ...
%     'Units','normalized','FontWeight','Bold', 'Foreground',[0.5 0 0],...
%     'Position',hpos,'string','Optimize','callback','pickpts_cb(''optimizepts'')');
% 
% hpos(1)=hpos(1)+hpos(3)+gap;
% hdl.optimizetxt=uicontrol(hdl.figure,'Style','text','Tag','points', ...
%     'Units','normalized','FontWeight','Bold', 'Foreground',[1 1 1],...
%     'Position',hpos,'string','within','background',[0.2 0 0]);
% 
% hpos(1)=hpos(1)+hpos(3)+gap;
% hdl.optimizetemplate=uicontrol(hdl.figure,'Style','popupmenu','Tag','points', ...
%     'Units','normalized','FontWeight','Bold', 'Foreground',[0.5 0 0],'value',2,...
%     'Position',hpos,'string','3x3|5x5|7x7|9x9|11x11|13x13|15x15|17x17|19x19');

pos(2)=pos(2)-pos(4)-gap;
hdl.roottip=uicontrol(hdl.figure,'Style','radiobutton','Tag','clickndraw', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[0.5 0 0],...
    'Position',pos,'string','Identify root tip','callback','pickpts_cb(''roottip'')');

pos(2)=pos(2)-pos(4)-2*gap;
hpos=pos;
hpos(3)=(pos(3)-2*gap)/3;
hdl.channeltext=uicontrol(hdl.figure,'Style','Text', ...
    'Units','normalized', 'background',[0.8 0.8 0.8],...
    'Position',hpos,'string','Color','Fontweight','Bold','Enable',others.color);

hpos(1)=hpos(1)+hpos(3)+gap;
hpos(3)=hpos(3)+2*gap;
hdl.col_channel=uicontrol(hdl.figure,'Style','popupmenu', ...
    'Units','normalized','Fontweight','Bold', ...
    'Position',hpos,'Tag','rootdia','value',4, ...
    'string','Red|Green|Blue|All','callback','rootdia_cb(''col_channel_check'')','Enable',others.color);

hpos(1)=hpos(1)+hpos(3)+gap;
hpos(3)=hpos(3)-4*gap;
hdl.col_channel_check=uicontrol(hdl.figure,'Style','togglebutton', ...
    'Units','normalized','Fontweight','Bold',...
    'Position',hpos,'Tag','rootdia', ...
    'string','Check','callback','rootdia_cb(''col_channel_check'')','Enable',others.color);

pos(2)=pos(2)-2*gap;
fpos=pos;
fpos(1)=fpos(1)-gap;
fpos(3)=fpos(3)+2*gap;
fpos(4)=fpos(4)*6+7*gap;
fpos(2)=fpos(2)-fpos(4);
hdl.trackframe=uicontrol(hdl.figure,'Style','Frame', ...
    'Units','normalized','Background',[0.3 0.3 0.3],...
    'Position',fpos,'Tag','track');

hpos=pos;
hpos(2)=hpos(2)-hpos(4)-gap;
hpos(3)=(hpos(3)-gap)/3;
pos(2)=hpos(2);
hdl.trackpts=uicontrol(hdl.figure,'Style','Pushbutton','Tag','track', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[0 0 0],...
    'Position',hpos,'string','Track','callback','track_cb(''trackpts'')');

hpos(1)=hpos(1)+hpos(3)+gap;
hpos(3)=hpos(3)*2;
hdl.trackmethod=uicontrol(hdl.figure,'Style','Popupmenu','Tag','track', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[0 0 0],'Value',2,...
    'Position',hpos,'string','Color Correlation|Correlation|Difference|Correlation & Diff.');

pos(2)=pos(2)-pos(4)-gap;
hpos=pos;
hpos(3)=(hpos(3)-gap)/2;
pos(2)=hpos(2);
if max(others.rootcolor) < 0.5,
 fgcolor=[1 1 1];
else
 fgcolor=[0 0 0];
end
hdl.rootcolor=uicontrol(hdl.figure,'Style','RadioButton','Tag','clickndraw', ...
    'Units','normalized','FontWeight','Bold','Background',others.rootcolor,...
    'Foreground',fgcolor,'Position',hpos,'string','Root color', ...
    'Callback','pickrootcolor(''rootcolor'')');

hpos(1)=hpos(1)+hpos(3)+gap;
if max(others.bgcolor) < 0.5,
 fgcolor=[1 1 1];
else
 fgcolor=[0 0 0];
end
hdl.bgcolor=uicontrol(hdl.figure,'Style','RadioButton','Tag','clickndraw', ...
    'Units','normalized','FontWeight','Bold','Background',others.bgcolor,...
    'Foreground',fgcolor,'Position',hpos,'string','Paper color','Callback',...
    'pickbgcolor(''bgcolor'')');

hpos=pos;
hpos(2)=hpos(2)-hpos(4)-gap;
hpos(3)=(hpos(3)-gap)*0.7;
pos(2)=hpos(2);
hdl.tracksearchtxt=uicontrol(hdl.figure,'Style','text','Tag','track', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[1 1 1],...
    'Position',hpos,'string','Search radius (R)', 'Background',[0.3 0.3 0.3]);

hpos(1)=hpos(1)+hpos(3)+gap;
hpos(3)=(pos(3)-gap)*0.3;
hdl.trackrad=uicontrol(hdl.figure,'Style','Edit','Tag','track', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[0 0 0],...
    'Position',hpos,'string','10');

hpos=pos;
hpos(2)=hpos(2)-hpos(4)-gap;
hpos(3)=(hpos(3)-gap)*0.7;
pos(2)=hpos(2);
hdl.tracktemplatetxt=uicontrol(hdl.figure,'Style','text','Tag','track', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[1 1 1],...
    'Position',hpos,'string','Template rad (N)', 'Background',[0.3 0.3 0.3]);

hpos(1)=hpos(1)+hpos(3)+gap;
hpos(3)=(pos(3)-gap)*0.3;
hdl.tracktemplate=uicontrol(hdl.figure,'Style','Edit','Tag','track', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[0 0 0],...
    'Position',hpos,'string','10');

hpos=pos;
hpos(2)=hpos(2)-hpos(4)-gap;
hpos(3)=(hpos(3)-gap)/2;
pos(2)=hpos(2);
hdl.trackhistorytxt=uicontrol(hdl.figure,'Style','text','Tag','track', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[1 1 1],...
    'Position',hpos,'string','History', 'Background',[0.3 0.3 0.3]);

hpos(1)=hpos(1)+hpos(3)+gap;
hdl.history=uicontrol(hdl.figure,'Style','Popupmenu','Tag','track', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[0 0 0],...
    'Position',hpos,'string',...
    'none|reference|reference+1|reference+2|reference+3|reference+4|reference+5|reference+6');

pos(2)=pos(2)-pos(4)-gap;
hdl.trackdirectional=uicontrol(hdl.figure,'Style','radiobutton','Tag','track', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[0 0 0],'value',1, ...
    'Position',pos,'string','Use growth direction');

pos(2)=pos(2)-pos(4)/2;
fpos=pos;
fpos(1)=fpos(1)-gap;
fpos(3)=fpos(3)+2*gap;
fpos(4)=fpos(4)*7+8*gap;
fpos(2)=fpos(2)-fpos(4);
hdl.edgeframe=uicontrol(hdl.figure,'Style','Frame', ...
    'Units','normalized','Background',[0.0 0.3 0.0],...
    'Position',fpos);

pos(2)=pos(2)-pos(4)-gap;
hpos=pos;
hpos(3)=(hpos(3)-gap)/2;
hdl.midlinebtn=uicontrol(hdl.figure,'Style','radiobutton',...
    'Units','normalized','FontWeight','Bold', 'foreground',[0 0.3 0],...
    'Position',hpos,'string','App. midline', ...
    'callback','rootdia_cb(''midline'')','value',others.midline);

pos(2)=pos(2)-pos(4)-gap;
hdl.diaestimate=uicontrol(hdl.figure,'Style','radiobutton', ...
    'Units','normalized','FontWeight','Bold', 'foreground',[0 0.3 0],...
    'Position',pos,'string','Estimate root Diameter', ...
    'callback','rootdia_cb(''diameter_est'')');

hpos(1)=hpos(1)+hpos(3)+gap;
hdl.outlinebtn=uicontrol(hdl.figure,'Style','radiobutton',...
    'Units','normalized','FontWeight','Bold', 'foreground',[0 0.3 0],...
    'Position',hpos,'string','Edge Det.', ...
    'callback','rootdia_cb(''edgedetection'')','value',abs(1-others.midline));

edgeswitch='on';
if others.midline==1,
    edgeswitch='off';
end

pos(2)=pos(2)-pos(4)-gap;
hpos=pos;
hpos(3)=(pos(3)-gap)/3;
hdl.edgetypetext=uicontrol(hdl.figure,'Style','Text', ...
    'Units','normalized', 'background',[0 0.3 0],...
    'Position',hpos,'string','Image Type','foreground',[1 1 1],'enable',edgeswitch);

hpos(1)=hpos(1)+hpos(3)+gap;
hpos(3)=2*hpos(3);
hdl.edgetype=uicontrol(hdl.figure,'Style','popupmenu', ...
    'Units','normalized', 'foreground',[0 0.3 0],...
    'Position',hpos,'Tag','rootdia','value',1, ...
    'string','Brighter root|Darker root|Brighter edge|Darker Edge','enable',edgeswitch);

pos(2)=pos(2)-pos(4)-gap;
hpos=pos;
hpos(3)=(pos(3)-gap)/3;
hdl.algotext=uicontrol(hdl.figure,'Style','Text', ...
    'Units','normalized', 'background',[0 0.3 0],...
    'Position',hpos,'string','Algorithm','foreground',[1 1 1],'enable',edgeswitch);

hpos(1)=hpos(1)+hpos(3)+gap;
hpos(3)=2*hpos(3);
hdl.algorithm=uicontrol(hdl.figure,'Style','popupmenu', ...
    'Units','normalized', 'foreground',[0 0.3 0],...
    'Position',hpos,'Tag','rootdia','value',1, ...
    'string','Edge finding|Gradient','enable',edgeswitch);

pos(2)=pos(2)-pos(4)-gap;
hpos=pos;
hpos(3)=(hpos(3)-2*gap)/3;
hdl.rootdiatext=uicontrol(hdl.figure,'Style','Text', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[1,1,1],...
    'Position',hpos,'string','Outline root','Tag','rootdia','background',[0 0.3 0],'enable',edgeswitch);

hpos(1)=hpos(1)+hpos(3)+gap;
hdl.rootdia=uicontrol(hdl.figure,'Style','Pushbutton', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[0 0.3 0],...
    'Position',hpos,'string','This image','Tag','rootdia', ...
    'callback','rootdia_cb(''rootdia'')','enable',edgeswitch);

hpos(1)=hpos(1)+hpos(3)+gap;
hdl.rootdia_all=uicontrol(hdl.figure,'Style','Pushbutton', ...
    'Units','normalized','FontWeight','Bold', 'Foreground',[0 0.3 0],...
    'Position',hpos,'string','All images','Tag','rootdia', ...
    'callback','rootdia_cb(''rootdia_all'')','enable',edgeswitch);

pos(2)=pos(2)-pos(4)-gap;
hpos=pos;
hpos(3)=pos(3)/2+2*gap;
str=sprintf('Filter size = %d',others.filterrad);
hdl.filtertext=uicontrol(hdl.figure,'Style','Text', ...
    'Units','normalized','FontWeight','Bold', 'background',[0 0.3 0],...
    'Position',hpos,'string',str,'foreground',[1 1 1],'Tag','rootdia',...
    'horizontalalignment','left','enable',edgeswitch);

hpos(1)=hpos(1)+hpos(3);
hpos(3)=hpos(3)-4*gap;
nn=size(img(others.cimage(:,:,1)).image);
n=round(min(nn(1:2))/2);
fmax=max(11,min(100,n));
hdl.filterrad=uicontrol(hdl.figure,'Style','slider', ...
    'Units','normalized','FontWeight','Bold', 'foreground',[0 0.3 0],...
    'Position',hpos,'Tag','rootdia','min',[0],'max',[fmax], ...
    'sliderstep',[1/fmax,10/fmax],'value',others.filterrad, ...
    'callback','rootdia_cb(''filterrad'')','enable',edgeswitch);

pos(2)=pos(2)-pos(4)-gap;
hdl.diaadjust=uicontrol(hdl.figure,'Style','radiobutton', ...
    'Units','normalized','FontWeight','Bold', 'foreground',[0 0.3 0],...
    'Position',pos,'string','Manually adjust outline','Tag','clickndraw', ...
    'callback','rootdia_cb(''diaadjust'')','enable',edgeswitch);

pos(2)=pos(2)-pos(4)/2;
fpos=pos;
fpos(1)=fpos(1)-gap;
fpos(3)=fpos(3)+2*gap;
fpos(4)=fpos(4)*4.6+2*gap;
fpos(2)=fpos(2)-fpos(4);
hdl.displayframe=uicontrol(hdl.figure,'Style','Frame', ...
    'Units','normalized','Background',[0.0 0.2 0.2],...
    'Position',fpos);

pos(2)=pos(2)-pos(4)/2-gap;
pos(4)=pos(4)*0.6;
hdl.show_pts=uicontrol(hdl.figure,'Style','text', ...
    'Units','normalized','Position',pos,'Background',[0.0 0.2 0.2], ...
    'String','Display options','Foreground',[1 1 1],'Fontweight','bold');

pos(4)=pos(4)/0.6;
pos(2)=pos(2)-pos(4)-gap/3;
hdl.show_pts=uicontrol(hdl.figure,'Style','popupmenu', ...
    'Units','normalized','Position',pos, ...
    'String','Marker points off|Marker points only|No Marker points but line|Marker points with line', ...
    'callback','display_cb(''points'')','value',others.pts_show);

pos(2)=pos(2)-pos(4)-gap/3;
hdl.show_roottip=uicontrol(hdl.figure,'Style','popupmenu', ...
    'Units','normalized','Position',pos, ...
    'String','Root tip off|Root tip on', ...
    'callback','display_cb(''root_tip'')','value',others.roottip_show);

pos(2)=pos(2)-pos(4)-gap/3;
hdl.show_outline=uicontrol(hdl.figure,'Style','popupmenu', ...
    'Units','normalized','Position',pos, ...
    'String','Outline off|Outline points only|Outline only|Outline with points', ...
    'callback','display_cb(''outline'')','value',others.outline_show);

pos(2)=pos(2)-pos(4)-gap/3;
hdl.show_centerline=uicontrol(hdl.figure,'Style','popupmenu', ...
    'Units','normalized','Position',pos, ...
    'String','Center line off|Center line points only|Center line only|Center line with points', ...
    'callback','display_cb(''centerline'')','value',others.centerline_show);

pos(2)=pos(2)-pos(4)-3*gap;
hdl.data_visual=uicontrol(hdl.figure,'Style','Pushbutton', ...
    'Units','normalized','Position',pos, ...
    'String','Visualize results', ...
    'callback','data_visual','FontWeight','bold');

pos(2)=pos(2)-pos(4)-gap/2;
hdl.save_results=uicontrol(hdl.figure,'Style','Pushbutton', ...
    'Units','normalized','Position',pos, ...
    'String','Save Measurements', ...
    'callback','save_results','FontWeight','bold');

pos(2)=pos(2)-pos(4)-1.5*gap;
hdl.deletepts=uicontrol(hdl.figure,'Style','pushbutton','Tag','points', ...
    'Units','normalized','FontWeight','Bold','Foreground',[0.5 0 0.5],...
    'Position',pos,'string','Reset measurements','callback','pickpts_cb(''resetall'')');

pos(2)=pos(2)-pos(4)-2*gap;
hdl.read_results=uicontrol(hdl.figure,'Style','Pushbutton', ...
    'Units','normalized','Position',pos, ...
    'String','Read measurements','Foreground',[0 0 0.5], ...
    'callback','read_results','FontWeight','bold');

pos(2)=pos(2)-pos(4)-gap/2;
hdl.readnew=uicontrol(hdl.figure,'Style','Pushbutton', ...
    'Units','normalized','Position',pos, ...
    'String','Read new set of images','Foreground',[0 0 0.5], ...
    'callback','kineroot_restart','FontWeight','bold');

return