function data_visual

data_process;
data_visualization;

return

%=====================================

function data_process

global others hdl img results;

clear global results;

global results;

k=length(img(1).cen_x);
idx1=(0:k-1)/(k-1);
idx2=(0:others.intpts-1)/(others.intpts-1);
n=length(img);
others.lmax=0;

for i=1:n,
    results(i).time=img(i).time;
    if img(i).edge_flag==1,
        results(i).cen_x=interp1(idx1,img(i).cen_x/others.scale,idx2,'spline');
        results(i).cen_y=interp1(idx1,img(i).cen_y/others.scale,idx2,'spline');
        results(i).dia1_x=interp1(idx1,img(i).rootdia1x/others.scale,idx2,'spline');
        results(i).dia1_y=interp1(idx1,img(i).rootdia1y/others.scale,idx2,'spline');
        results(i).dia2_x=interp1(idx1,img(i).rootdia2x/others.scale,idx2,'spline');
        results(i).dia2_y=interp1(idx1,img(i).rootdia2y/others.scale,idx2,'spline');
    else
        results(i).cen_x(1:others.intpts)=0.0;
        results(i).cen_y(1:others.intpts)=0.0;
        results(i).dia1_x(1:others.intpts)=0.0;
        results(i).dia1_y(1:others.intpts)=0.0;
        results(i).dia2_x(1:others.intpts)=0.0;
        results(i).dia2_y(1:others.intpts)=0.0;
    end

    results(i).lc(1)=0.0;
    results(i).l1(1)=0.0;
    results(i).l2(1)=0.0;
    results(i).dia(1)=0.0;
    for j=2:others.intpts,
        results(i).lc(j)=results(i).lc(j-1)+ ...
                            sqrt((results(i).cen_x(j)-results(i).cen_x(j-1))^2+ ...
                                 (results(i).cen_y(j)-results(i).cen_y(j-1))^2);
        results(i).l1(j)=results(i).l1(j-1)+ ...
                            sqrt((results(i).dia1_x(j)-results(i).dia1_x(j-1))^2+ ...
                                 (results(i).dia1_y(j)-results(i).dia1_y(j-1))^2);
        results(i).l2(j)=results(i).l2(j-1)+ ...
                            sqrt((results(i).dia2_x(j)-results(i).dia2_x(j-1))^2+ ...
                                 (results(i).dia2_y(j)-results(i).dia2_y(j-1))^2);
                              
        results(i).dia(j)=sqrt((results(i).dia1_x(j)-results(i).dia2_x(j))^2+ ...
                               (results(i).dia1_y(j)-results(i).dia2_y(j))^2);
        if i>1,
            if results(i).lc(j)<results(i-1).lc(j),
                results(i).lc(j)=results(i-1).lc(j);
            end
            if results(i).l1(j)<results(i-1).l1(j),
                results(i).l1(j)=results(i-1).l1(j);
            end
            if results(i).l2(j)<results(i-1).l2(j),
                results(i).l2(j)=results(i-1).l2(j);
            end
        end
    end
    others.lmax=max([others.lmax,results(i).lc(others.intpts), ...
        results(i).l1(others.intpts),results(i).l2(others.intpts)]); 
end

others.conts_del=10;
others.conts_no=10;
others.conts=[];
others.cmap=8;
others.itermax=5;
others.conv_crit=0.01;
others.sfac=3;
others.bindx=1.5*others.lmax/(length(results(end).lc));
others.bin=0:others.bindx:others.lmax+others.bindx;
others.binno=length(others.bin)-1;

return

%=========================================================

function data_visualization

global hdl img others results;

hdl.visualfig=figure('name','Data visualization','doublebuffer','on');

others.plottype=1;

hdl.plot=uimenu(hdl.visualfig,'Label','plot');

hdl.growthchart=uimenu(hdl.plot,'Label','Root length map', ...
    'Callback','plotdata(''growthchart'')','Tag','plot');

hdl.growthrate_c=uimenu(hdl.plot,'Label','Center line growth Rate','Tag','plot');
    hdl.growthrate_c_raw=uimenu(hdl.growthrate_c,'Label','Raw data', ...
    'callback','plotdata(''growthrate_c_raw'')','Tag','plot');
    hdl.growthrate_c_mean=uimenu(hdl.growthrate_c,'Label','Mean data with SE', ...
    'callback','plotdata(''growthrate_c_mean'')','Tag','plot');
    hdl.growthrate_c_iso=uimenu(hdl.growthrate_c,'Label','Isocontour', ...
    'callback','plotdata(''growthrate_c_iso'')','Tag','plot');

hdl.curvature_c=uimenu(hdl.plot,'Label','Center line curvature','Tag','plot');
    hdl.curvature_c_raw=uimenu(hdl.curvature_c,'Label','Raw data', ...
    'callback','plotdata(''curvature_c_raw'')','Tag','plot');
    hdl.curvature_c_mean=uimenu(hdl.curvature_c,'Label','Mean data with SE', ...
    'callback','plotdata(''curvature_c_mean'')','Tag','plot');
    hdl.curvature_c_iso=uimenu(hdl.curvature_c,'Label','Isocontour', ...
    'callback','plotdata(''curvature_c_iso'')','Tag','plot');

hdl.diameter=uimenu(hdl.plot,'Label','Root diameter','Tag','plot');
    hdl.diameter_raw=uimenu(hdl.diameter,'Label','Raw data', ...
    'callback','plotdata(''diameter_raw'')','Tag','plot');
    hdl.diameter_mean=uimenu(hdl.diameter,'Label','Mean data with SE', ...
    'callback','plotdata(''diameter_mean'')','Tag','plot');
    hdl.diameter_iso=uimenu(hdl.diameter,'Label','Isocontour', ...
    'callback','plotdata(''diameter_iso'')','Tag','plot');

hdl.contprop=uimenu(hdl.plot,'Label','Contour properties','Separator','on', ...
    'callback','contprop(''contpropini'')','enable','off');
hdl.plotprop=uimenu(hdl.plot,'Label','Data processing parameters', ...
    'callback','plotprop(''plotpropini'')','enable','off');

hdl.save=uimenu(hdl.visualfig,'Label','Save data','enable','off');
hdl.savetec=uimenu(hdl.save,'Label','Save data for Tecplot', ...
    'callback','savedata(''savetec'')');
hdl.savetxt=uimenu(hdl.save,'Label','Save in text file', ...
    'callback','savedata(''savetxt'')');

hdl.plotaxis=axes();

return