function [xn,yn,varargout]=drop_normalHR(cx,cy,x,y)


varargout(1)={0};
if length(cx)~=length(cy)
    disp('Lengths vectors do not match. Normal cannot be dropped');
    xn=x;
    yn=y;
    return
end

xn=-1000;
yn=-1000;

if length(cx)==1,
 xn=x;
 yn=y;
elseif length(cx)==2,
 ex=cx(2)-cx(1);
 ey=cy(2)-cy(1);
 e=sqrt(ex*ex+ey*ey);

 vx=x-cx(1);
 vy=y-cy(1);
 v=sqrt(vx*vx+vy*vy);

 if e > 0.0,
  ex=ex/e;
  ey=ey/e;

  dist=vx*ex+vy*ey;
  xn=cx(1)+ex*dist;
  yn=cy(1)+ey*dist;
 else
  xn=cx(1);
  yn=cy(1);
 end
elseif length(cx) > 2,

 idx1=(0:1:(length(cx)-1))/(length(cx)-1);
 idx2=0:0.1:1;
 xx=interp1(idx1,cx,idx2,'linear');
 yy=interp1(idx1,cy,idx2,'linear');

 ex=xx(2)-xx(1);
 ey=yy(2)-yy(1);
 e=sqrt(ex*ex+ey*ey);
 ex=ex/e;
 ey=ey/e;
 
 x0=xx(1)-1000*ex;
 y0=yy(1)-1000*ey;
 
 ex=xx(end)-xx(end-1);
 ey=yy(end)-yy(end-1);
 e=sqrt(ex*ex+ey*ey);
 ex=ex/e;
 ey=ey/e;
 
 xl=xx(end)+1000*ex;
 yl=yy(end)+1000*ey;
 
 xx=[x0 xx xl];
 yy=[y0 yy yl];
 
 ns=length(xx);

 for j=1:ns-1,
     ex=xx(j+1)-xx(j);
     ey=yy(j+1)-yy(j);
     e=sqrt(ex*ex+ey*ey);
     ex=ex/e;
     ey=ey/e;
     vx=x-xx(j);
     vy=y-yy(j);
     v=vx*ex+vy*ey;
     if v >= 0.0 & v <= e,
         xn=xx(j)+v*ex;
         yn=yy(j)+v*ey;
         break;
     end
 end
 
 if xn==-1000 | yn==-1000
     varargout(1)={1};
%      disp('Normal not found. Using nearest point');
     dist=1e20;
     for j=2:ns-1,
         d=(x-xx(j))^2+(y-yy(j))^2;
         if d<dist,
             dist=d;
             xn=xx(j);
             yn=yy(j);
         end
     end
 end
end

return
