function [xn,yn]=intersection(cx,cy,x,y,vx,vy)

if length(cx)~=length(cy)
    disp('Lengths vectors do not match. Normal cannot be dropped');
    xn=x;
    yn=y;
    return
end

xn=-1000;
yn=-1000;

if length(cx)==1,
 xn=x;
 yn=y;
elseif length(cx) > 1,
    flag=0;
    idx1=(0:length(cx)-1)/(length(cx)-1);
    idx2=0:0.01:1;
    xx=interp1(idx1,cx,idx2,'linear');
    yy=interp1(idx1,cy,idx2,'linear');
    
    ex=xx(2)-xx(1);
    ey=yy(2)-yy(1);
    e=sqrt(ex*ex+ey*ey);
    ex=ex/e;
    ey=ey/e;
 
    x0=xx(1)-1000*ex;
    y0=yy(1)-1000*ey;
 
    ex=xx(end)-xx(end-1);
    ey=yy(end)-yy(end-1);
    e=sqrt(ex*ex+ey*ey);
    ex=ex/e;
    ey=ey/e;
 
    xl=xx(end)+1000*ex;
    yl=yy(end)+1000*ey;
 
    xx=[x0 xx xl];
    yy=[y0 yy yl];
    xb=x+1000*vx;
    yb=y+1000*vy;
    xc=x-1000*vx;
    yc=y-1000*vy;
    
    for i=1:length(xx)-1,
        xa=xx(i);
        ya=yy(i);
        xd=xx(i+1);
        yd=yy(i+1);

        [xe,ye,fac]=xsect(xa,ya,xb,yb,xc,yc,xd,yd);
        if fac==1,
            xn=xe;
            yn=ye;
            flag=1;
            break;
        end
    end
    
    if flag==0,
%         disp('Point of intersection not found. Using nearest point');
        dist=1e20;
        for j=2:length(xx)-1,
         d=(x-xx(j))^2+(y-yy(j))^2;
         if d<dist,
             dist=d;
             xn=xx(j);
             yn=yy(j);
         end
        end
    end
end

return