function pickrootcolor(action, varargin)

global hdl;
%exclusive radio buttons
h1=gcbo;
if strncmpi(get(h1,'Type'),'uicontrol',4)==1,
 if strncmpi(get(h1,'Style'),'radiobutton',4)==1,
    h=findobj(hdl.figure,'style','radiobutton','Tag','clickndraw');
    for i=1:length(h),
     if eq(h(i),h1)==0 & eq(h(i),hdl.trackdirectional)==0,
       set(h(i),'value',0);
     end
    end
%     zoom off;
%     set(hdl.zoom,'value',[0],'Foreground',[0 0 0]);
 end
end

if nargin>=1,
 feval(action,varargin{:});
end

return;

%
%================
%

function rootcolor

global hdl;

if hdl.rootcolorline > 0.0,
    delete(hdl.rootcolorline);
    hdl.rootcolorline=-1;
end
mes_flag=get(hdl.rootcolor,'Value');
if mes_flag==1
 set(hdl.figure, 'WindowButtonDownFcn', 'pickrootcolor(''ButtonDownOnMano'')');
end

return

%
%================
%

function ButtonDownOnMano

global hdl others;

pt = get(gca, 'CurrentPoint');
others.rcbox_x0 = pt(1,1); 
others.rcbox_y0 = pt(1,2); 
others.rcbox_x1 = others.rcbox_x0;
others.rcbox_y1 = others.rcbox_y0;
hdl.rootcolorline=line([others.rcbox_x0, others.rcbox_x1, others.rcbox_x1, ...
    others.rcbox_x0, others.rcbox_x0],...
    [others.rcbox_y0, others.rcbox_y0, others.rcbox_y1, others.rcbox_y1, ...
    others.rcbox_y0],'erasemode', 'xor');
set(hdl.figure, 'WindowButtonMotionFcn', 'pickrootcolor(''DrawLine'')');
set(hdl.figure, 'WindowButtonUpFcn', 'pickrootcolor(''BackToNormalcy'')');

return


function DrawLine

global hdl others;

 if hdl.rootcolorline>0.0
  delete(hdl.rootcolorline);
 end

 pt = get(gca, 'CurrentPoint');
 others.rcbox_x1 = pt(1,1); 
 others.rcbox_y1 = pt(1,2);
 hdl.rootcolorline=line([others.rcbox_x0, others.rcbox_x1, others.rcbox_x1, ...
    others.rcbox_x0, others.rcbox_x0],...
    [others.rcbox_y0, others.rcbox_y0, others.rcbox_y1, others.rcbox_y1, ...
    others.rcbox_y0],'erasemode', 'xor');
return

%%%
%%%  Sub-function - BackToNormalcy
%%%

function BackToNormalcy

global others hdl img;

if hdl.rootcolorline >0.0
 delete(hdl.rootcolorline);
 hdl.rootcolorline=-1;
end

set(hdl.figure, 'WindowButtonDownFcn', '');
set(hdl.figure, 'WindowButtonMotionFcn', '');
set(hdl.figure, 'WindowButtonUpFcn', '');

x0=round(others.rcbox_x0);
y0=round(others.rcbox_y0);
x1=round(others.rcbox_x1);
y1=round(others.rcbox_y1);

others.rootcolor=mean(mean(img(others.cimage).image(min(y0,y1):max(y0,y1),min(x0,x1):max(x0,x1),:)));
if max(others.rootcolor)>1
    others.rootcolor=others.rootcolor/255;
end

if max(others.bgcolor) < 0.5,
 fgcolor=[1 1 1];
else
 fgcolor=[0 0 0];
end

set(hdl.rootcolor,'Value',0,'Background',others.rootcolor,'Foreground',fgcolor);

return