function rootdia_cb(action, varargin)

global hdl;

%exclusive radio buttons
h1=gcbo;
if strncmpi(get(h1,'Type'),'uicontrol',4)==1,
 if strncmpi(get(h1,'Style'),'radiobutton',4)==1,
    h=findobj(hdl.figure,'style','radiobutton','Tag','clickndraw');
    for i=1:length(h),
     if eq(h(i),h1)==0 & eq(h(i),hdl.trackdirectional)==0,
       set(h(i),'value',0);
     end
    end
    zoom off;
%     set(hdl.zoom,'value',[0],'Foreground',[0 0 0]);
 end
end

if nargin>=1,
feval(action,varargin{:});
end
return;

%=====================

function diameter_est

global hdl;

if hdl.diaestline > 0.0,
    delete(hdl.diaestline);
    hdl.diaestline=-1;
end

dia_flag=get(hdl.diaestimate,'Value');
if dia_flag==1
 set(hdl.figure, 'WindowButtonDownFcn', 'rootdia_cb(''ButtonDownOnMano'')');
else
 return;
end

return

%================

function ButtonDownOnMano

global hdl others;

pt = get(gca, 'CurrentPoint');
others.diax0 = pt(1,1); 
others.diay0 = pt(1,2); 
others.diax1 = others.diax0;
others.diay1 = others.diay0;
hdl.diaestline=line([others.diax1 others.diax0],[others.diay1 others.diay0],'erasemode', 'xor');
set(hdl.figure, 'WindowButtonMotionFcn', 'rootdia_cb(''DrawLine'')');
set(hdl.figure, 'WindowButtonUpFcn', 'rootdia_cb(''BackToNormalcy'')');

return

%=======================

function DrawLine

global hdl others;

 if hdl.diaestline>0.0
  delete(hdl.diaestline);
 end

 pt = get(gca, 'CurrentPoint');
 others.diax1 = pt(1,1);
 others.diay1 = pt(1,2);
 hdl.diaestline=line([others.diax1 others.diax0],[others.diay1 others.diay0],'erasemode', 'xor');
return

%===================================

function BackToNormalcy

global others hdl;

set(hdl.figure, 'WindowButtonDownFcn', '');
set(hdl.figure, 'WindowButtonMotionFcn', '');
set(hdl.figure, 'WindowButtonUpFcn', '');
set(hdl.diaestimate,'Value',0);

others.diaest=sqrt((others.diax1-others.diax0)^2+(others.diay1-others.diay0)^2);

return

%=====================

function filterrad

global hdl img others;

others.filterrad=round(get(hdl.filterrad,'value'));
str=sprintf('Filter size = %d',others.filterrad);
set(hdl.filtertext,'string',str);

return

%===================

function rootdia

global hdl img others;

m=others.cimage;
if img(m).npts<=0,
    warndlg('Select points on the root first','Root points alert');
    return
end
if others.roottip<=0,
    warndlg('Select root tip','Root tip alert');
    return
end
if others.diaest<=0.0,
    warndlg('Please provide an estimate of root diameter');
    return
end

f=get(hdl.algorithm,'value');
if f==1,
 stat=find_root_edge(m,1);
else
 stat=find_root_gradient(m);
end

set(hdl.show_pts,'value',2);
set(hdl.show_outline,'value',3);
h=findobj(hdl.figure,'style','radiobutton','Tag','clickndraw');
for i=1:length(h),
   set(h(i),'value',0);
end
zoom off;
others.pts_show=2;
others.outline_show=3;

if stat==1,
 imagedraw(m);
 drawothers(m);
end

return

%=====================================

function rootdia_all

global hdl img others;

for i=2:length(img),
   if img(i).npts~=img(i-1).npts,
     str=sprintf('Image %d has does not have same number of points as other images. Root outline cannot be done', i); 
     warndlg(str,'Uneven no. of points');
     return
     break
   end
end
if others.roottip<=0,
    warndlg('Select root tip','Root tip alert');
    return
end
if others.diaest<=0.0,
    warndlg('Please provide an estimate of root diameter');
    return
end

f=get(hdl.algorithm,'value');


h=mywaitbar(0,'Generating root outlines');
for m=1:length(img),
    if f==1,
        stat=find_root_edge(m,0);
    else
        stat=find_root_gradient(m);
    end
    mywaitbar(m/length(img));
end
velocitycheck;
close(h);

set(hdl.show_pts,'value',2);
set(hdl.show_outline,'value',3);
h=findobj(hdl.figure,'style','radiobutton','Tag','clickndraw');
for i=1:length(h),
   set(h(i),'value',0);
end
zoom off;
others.pts_show=2;
others.outline_show=3;

if stat==1,
 drawothers(others.cimage);
end

return

%=====================================

function velocitycheck

global hdl img others;

for i=1:length(img),
    store(i).cen_x=img(i).cen_x;
    store(i).cen_y=img(i).cen_y;
end

ncs=length(img(1).cen_x);
for n=1:30,
  flag=1;
  for i=2:length(img),
    vx=img(i).cen_x-img(i-1).cen_x;
    vy=img(i).cen_y-img(i-1).cen_y;
    v=sqrt(vx.^2+vy.^2);
    for j=2:ncs,
        if v(j)-v(j-1)>eps,
            flag=0;
            e=v(j)-v(j-1);      
            f1=0.5*e;
            f2=0.5*e;

            if v(j-1)>0.0 & j-1>1,
                img(i).cen_x(j-1)=img(i).cen_x(j-1)+f2*vx(j-1)/v(j-1);
                img(i).cen_y(j-1)=img(i).cen_y(j-1)+f2*vy(j-1)/v(j-1);
                img(i).cen_x(j)=img(i).cen_x(j)-f1*vx(j)/v(j);
                img(i).cen_y(j)=img(i).cen_y(j)-f1*vy(j)/v(j);
            else
                img(i).cen_x(j)=img(i).cen_x(j)-e*vx(j)/v(j);
                img(i).cen_y(j)=img(i).cen_y(j)-e*vy(j)/v(j);
            end
            vx(j-1:j)=img(i).cen_x(j-1:j)-img(i-1).cen_x(j-1:j);
            vy(j-1:j)=img(i).cen_y(j-1:j)-img(i-1).cen_y(j-1:j);
            v(j-1:j)=sqrt(vx(j-1:j).^2+vy(j-1:j).^2);
        end
    end
  end
  if flag==1,
      break;
  end
end

for m=2:length(img),
    for i=2:ncs-1,
        vy(i)=-(img(m).cen_x(i+1)-img(m).cen_x(i-1))/2;
        vx(i)= (img(m).cen_y(i+1)-img(m).cen_y(i-1))/2;
    end
    vy(ncs)=-(img(m).cen_x(ncs)-img(m).cen_x(ncs-1))/2;
    vx(ncs)= (img(m).cen_y(ncs)-img(m).cen_y(ncs-1))/2;

    cx(1)=img(m).ptsx(1);
    cy(1)=img(m).ptsy(1);
    for i=2:ncs,
        [cx(i),cy(i)]=intersection(img(m).rootdia1x,img(m).rootdia1y, ...
        img(m).cen_x(i),img(m).cen_y(i),vx(i),vy(i));  
    end
    img(m).rootdia1x=cx;
    img(m).rootdia1y=cy;
    
    cx(1)=img(m).ptsx(1);
    cy(1)=img(m).ptsy(1);
    for i=2:ncs,
        [cx(i),cy(i)]=intersection(img(m).rootdia2x,img(m).rootdia2y, ...
        img(m).cen_x(i),img(m).cen_y(i),vx(i),vy(i));  
    end
    img(m).rootdia2x=cx;
    img(m).rootdia2y=cy;
end

return

%=====================================
function stat=find_root_edge(m,flag)

global hdl img others;

% apply gaussian blur on the image and calculate the gradient
r=others.filterrad;
nseg=others.nseg;

if r<1,
    errordlg('Filter size >= 1 is required for root edge finding algorithm','Incompatible filter size');
    stat=0;
    return
end

img(m).rootdia1x=[];
img(m).rootdia1y=[];
img(m).rootdia2x=[];
img(m).rootdia2y=[];
img(m).cen_x=[];
img(m).cen_y=[];

c=1;
if strncmp(others.color,'on',2)
    c=get(hdl.col_channel,'value');
end

edgetype=get(hdl.edgetype,'value');

n=size(img(m).image);

xmin=max(1,round(min(img(m).ptsx)-2*others.diaest));
xmax=min(n(2),round(max(img(m).ptsx)+2*others.diaest));
ymin=max(1,round(min(img(m).ptsy)-2*others.diaest));
ymax=min(n(1),round(max(img(m).ptsy)+2*others.diaest));

if c==4,
    fimg=mean(single(img(m).image(ymin:ymax,xmin:xmax,:)),3);
else
    fimg=single(img(m).image(ymin:ymax,xmin:xmax,c));
end

if edgetype<3
    [fimg,ax,ay]=nonmaxsup(fimg,r);
else
    [fimg,ax,ay]=nonmaxsup_line_edge(fimg,r);
end

% calculate the velocity vectors of the selected points
vx(1:img(m).npts)=0.0;
vy(1:img(m).npts)=0.0;

[p,s]=polyfit(img(m).ptsx,img(m).ptsy,2);
if p(1)==0,
    p(1)=eps;
end
theta=atan(-1/p(1));
vx(:)=cos(theta);
vy(:)=sin(theta);

% now find the root edge - 1st iteration
nn=size(fimg);
nx=round(others.diaest)*2;
dx=1.1*others.diaest/nx;

for i=2:img(m).npts,
  x=img(m).ptsx(i)-vx(i)*dx*(0:nx)-xmin+1;
  y=img(m).ptsy(i)-vy(i)*dx*(0:nx)-ymin+1;
  nx1=max(1,round(min(x)-3));
  nx2=min(nn(2),round(max(x)+3));
  ny1=max(1,round(min(y)-3));
  ny2=min(nn(1),round(max(y)+3));
  [ix,iy]=meshgrid(nx1:nx2,ny1:ny2);
  g=interp2(ix-nx1+1,iy-ny1+1,fimg(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  [gmax,gmaxi]=max(g);
  img(m).rootdia1x(i)=x(gmaxi)+xmin-1;
  img(m).rootdia1y(i)=y(gmaxi)+ymin-1;
end
img(m).rootdia1x(1)=img(m).ptsx(1);
img(m).rootdia1y(1)=img(m).ptsy(1);

for i=2:img(m).npts,
  x=img(m).ptsx(i)+vx(i)*dx*(0:nx)-xmin+1;
  y=img(m).ptsy(i)+vy(i)*dx*(0:nx)-ymin+1;
  nx1=max(1,round(min(x)-3));
  nx2=min(nn(2),round(max(x)+3));
  ny1=max(1,round(min(y)-3));
  ny2=min(nn(1),round(max(y)+3));
  [ix,iy]=meshgrid(nx1:nx2,ny1:ny2);
  g=interp2(ix-nx1+1,iy-ny1+1,fimg(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  [gmax,gmaxi]=max(g);
  img(m).rootdia2x(i)=x(gmaxi)+xmin-1;
  img(m).rootdia2y(i)=y(gmaxi)+ymin-1;
end
img(m).rootdia2x(1)=img(m).ptsx(1);
img(m).rootdia2y(1)=img(m).ptsy(1);


img(m).cen_x=(img(m).rootdia1x+img(m).rootdia2x)/2;
img(m).cen_y=(img(m).rootdia1y+img(m).rootdia2y)/2;

%define root center for 2nd iteration        
cx(1)=img(m).ptsx(1);
cy(1)=img(m).ptsy(1);
for i=2:img(m).npts,
 [cx(i),cy(i)]=drop_normal(img(m).cen_x,img(m).cen_y,img(m).ptsx(i),img(m).ptsy(i));  
end
img(m).cen_x=cx;
img(m).cen_y=cy;

%root edge - 2nd iteration
vx(1)=0.0;
vy(1)=0.0;

for i=2:img(m).npts,
   vx(i)=img(m).cen_x(i)-img(m).cen_x(i-1);
   vy(i)=img(m).cen_y(i)-img(m).cen_y(i-1);
   v(i)=sqrt(vx(i)*vx(i)+vy(i)*vy(i));
   if v(i)>eps,
       vx(i)=vx(i)/v(i);
       vy(i)=vy(i)/v(i);
   end
end

for i=2:img(m).npts,
  x=img(m).cen_x(i)+vy(i)*dx*(0:nx)-xmin+1;
  y=img(m).cen_y(i)-vx(i)*dx*(0:nx)-ymin+1;
  nx1=max(1,round(min(x)-3));
  nx2=min(nn(2),round(max(x)+3));
  ny1=max(1,round(min(y)-3));
  ny2=min(nn(1),round(max(y)+3));
  [ix,iy]=meshgrid(nx1:nx2,ny1:ny2);
  g=interp2(ix-nx1+1,iy-ny1+1,fimg(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  [gmax,gmaxi]=max(g);
  img(m).rootdia1x(i)=x(gmaxi)+xmin-1;
  img(m).rootdia1y(i)=y(gmaxi)+ymin-1;
end

for i=1:img(m).npts,
  x=img(m).cen_x(i)-vy(i)*dx*(0:nx)-xmin+1;
  y=img(m).cen_y(i)+vx(i)*dx*(0:nx)-ymin+1;
  nx1=max(1,round(min(x)-3));
  nx2=min(nn(2),round(max(x)+3));
  ny1=max(1,round(min(y)-3));
  ny2=min(nn(1),round(max(y)+3));
  [ix,iy]=meshgrid(nx1:nx2,ny1:ny2);
  g=interp2(ix-nx1+1,iy-ny1+1,fimg(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  [gmax,gmaxi]=max(g);
  img(m).rootdia2x(i)=x(gmaxi)+xmin-1;
  img(m).rootdia2y(i)=y(gmaxi)+ymin-1;
end

img(m).cen_x=(img(m).rootdia1x+img(m).rootdia2x)/2;
img(m).cen_y=(img(m).rootdia1y+img(m).rootdia2y)/2;

%define root center for 3rd iteration
cx(1)=img(m).ptsx(1);
cy(1)=img(m).ptsy(1);
for i=2:img(m).npts,
 [cx(i),cy(i)]=drop_normal(img(m).cen_x,img(m).cen_y,img(m).ptsx(i),img(m).ptsy(i));
end

    idx1=(0:img(m).npts-1)/(img(m).npts-1);
    idx2=0:1/nseg:1;

    img(m).cen_x=interp1(idx1,cx,idx2,'linear');
    img(m).cen_y=interp1(idx1,cy,idx2,'linear');

clear vx vy;
ncs=length(img(m).cen_x);
vx(1)=img(m).cen_x(2)-img(m).cen_x(1);
vy(1)=img(m).cen_y(2)-img(m).cen_y(1);
for i=2:ncs-1,
    vx(i)=0.5*(img(m).cen_x(i+1)-img(m).cen_x(i-1));
    vy(i)=0.5*(img(m).cen_y(i+1)-img(m).cen_y(i-1));
end
vx(ncs)=img(m).cen_x(ncs)-img(m).cen_x(ncs-1);
vy(ncs)=img(m).cen_y(ncs)-img(m).cen_y(ncs-1);

v=sqrt(vx.*vx+vy.*vy);
vx=vx./v;
vy=vy./v;

clear cx cy;
cx(1)=img(m).ptsx(1);
cy(1)=img(m).ptsy(1);

for i=2:ncs,
  x=img(m).cen_x(i)+vy(i)*dx*(0:nx)-xmin+1;
  y=img(m).cen_y(i)-vx(i)*dx*(0:nx)-ymin+1;
  nx1=max(1,round(min(x)-3));
  nx2=min(nn(2),round(max(x)+3));
  ny1=max(1,round(min(y)-3));
  ny2=min(nn(1),round(max(y)+3));
  [ix,iy]=meshgrid(nx1:nx2,ny1:ny2);
  g=interp2(ix-nx1+1,iy-ny1+1,fimg(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  [gmax,gmaxi]=max(g);
  cx(i)=x(gmaxi)+xmin-1;
  cy(i)=y(gmaxi)+ymin-1;
end
img(m).rootdia1x=cx;
img(m).rootdia1y=cy;

for i=2:ncs,
  x=img(m).cen_x(i)-vy(i)*dx*(0:nx)-xmin+1;
  y=img(m).cen_y(i)+vx(i)*dx*(0:nx)-ymin+1;
  nx1=max(1,round(min(x)-3));
  nx2=min(nn(2),round(max(x)+3));
  ny1=max(1,round(min(y)-3));
  ny2=min(nn(1),round(max(y)+3));
  [ix,iy]=meshgrid(nx1:nx2,ny1:ny2);
  g=interp2(ix-nx1+1,iy-ny1+1,fimg(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  [gmax,gmaxi]=max(g);
  cx(i)=x(gmaxi)+xmin-1;
  cy(i)=y(gmaxi)+ymin-1;
end
img(m).rootdia2x=cx;
img(m).rootdia2y=cy;

img(m).cen_x=(img(m).rootdia1x+img(m).rootdia2x)/2;
img(m).cen_y=(img(m).rootdia1y+img(m).rootdia2y)/2;
img(m).edge_flag=1;

if flag==1,
 ffimg=zeros(n(1),n(2));
 ffimg(ymin:ymax,xmin:xmax)=fimg;
 
 hdl.pts=-1;
 hdl.roottippt=-1;
 hdl.scaleline=-1;
 hdl.diaestline=-1;
 hdl.outline=-1;
 hdl.centerline=-1;
 drawothers(m);
end

stat=1;

return

%=================================

function diaadjust

global hdl img others;

m=others.cimage;

if get(hdl.diaadjust,'value')==0 | img(m).edge_flag==0 | hdl.outline<0,
    set(hdl.diaadjust,'value',0);
    return
end
set(hdl.figure, 'WindowButtonDownFcn', 'rootdia_cb(''diaadjust_ButtonDown'')');

return

%=====================================================

function diaadjust_ButtonDown

global hdl img others;

if strncmp(get(gcf, 'SelectionType'),'normal',6) ~=1,
 set(hdl.figure, 'WindowButtonDownFcn', '');
 set(hdl.diaadjust, 'Value', 0);
 return
end

m=others.cimage;

pt=round(get(gca, 'CurrentPoint'));
dist=25;
others.diapt=0;
others.dialine=1;
for i=1:length(img(m).cen_x),
 d=(img(m).rootdia1x(i)-pt(1,1))^2+(img(m).rootdia1y(i)-pt(1,2))^2;
 if d<dist,
  dist=d;
  others.diapt=i;
  others.dialine=1;
 end
 d=(img(m).rootdia2x(i)-pt(1,1))^2+(img(m).rootdia2y(i)-pt(1,2))^2;
 if d<dist,
  dist=d;
  others.diapt=i;
  others.dialine=2;
 end
end

if others.diapt==0|others.diapt==others.roottip,
 return
end

set(hdl.figure, 'WindowButtonMotionFcn', 'rootdia_cb(''diaadjust_redraw'')');
set(hdl.figure, 'WindowButtonUpFcn', 'rootdia_cb(''diaadjust_final'')');

return

%=====================================================

function diaadjust_redraw

global hdl img others;

if strncmp(get(gcf, 'SelectionType'),'normal',6) ~=1,
 set(hdl.figure, 'WindowButtonDownFcn', '');
 set(hdl.diaadjust, 'Value', 0);
 return
end

m=others.cimage;
n=others.diapt;
p=others.dialine;

pt=round(get(gca, 'CurrentPoint'));
imgsize=size(img(others.cimage).image);
if pt(1,1)>=1 & pt(1,1)<=imgsize(2) & pt(1,2)>=1 & pt(1,2)<=imgsize(1),
    if p==1,
        img(m).rootdia1x(n)=pt(1,1);
        img(m).rootdia1y(n)=pt(1,2);
    else
        img(m).rootdia2x(n)=pt(1,1);
        img(m).rootdia2y(n)=pt(1,2);
    end
    img(m).cen_x(n)=(img(m).rootdia1x(n)+img(m).rootdia2x(n))/2;
    img(m).cen_y(n)=(img(m).rootdia1y(n)+img(m).rootdia2y(n))/2;
end
drawothers(m);

return

%======================================================

function diaadjust_final

global hdl img others;
                                                                                                                  
if strncmp(get(gcf, 'SelectionType'),'normal',6) ~=1,
 set(hdl.figure, 'WindowButtonDownFcn', '');
 set(hdl.diaadjust, 'Value', 0);
 return
end
                                                                                                                  
m=others.cimage;
n=others.diapt;
p=others.dialine;
imgsize=size(img(others.cimage).image);

pt=round(get(gca, 'CurrentPoint'));

if pt(1,1)>=1 & pt(1,1)<=imgsize(2) & pt(1,2)>=1 & pt(1,2)<=imgsize(1),
    if p==1,
        img(m).rootdia1x(n)=pt(1,1);
        img(m).rootdia1y(n)=pt(1,2);
    else
        img(m).rootdia2x(n)=pt(1,1);
        img(m).rootdia2y(n)=pt(1,2);
    end
    img(m).cen_x(n)=(img(m).rootdia1x(n)+img(m).rootdia2x(n))/2;
    img(m).cen_y(n)=(img(m).rootdia1y(n)+img(m).rootdia2y(n))/2;
end
drawothers(m);

set(hdl.figure, 'WindowButtonMotionFcn','');
set(hdl.figure, 'WindowButtonUpFcn','');

return

%====================================================

function stat=find_root_gradient(m)

global hdl img others;

% apply gaussian blur on the image and calculate the gradient
r=others.filterrad;
c=get(hdl.col_channel,'value');
stat=1;
nseg=others.nseg;

img(m).rootdia1x=[];
img(m).rootdia1y=[];
img(m).rootdia2x=[];
img(m).rootdia2y=[];
img(m).cen_x=[];
img(m).cen_y=[];

n=size(img(m).image);
edgetype=get(hdl.edgetype,'value');

xmin=max(1,round(min(img(m).ptsx)-2*others.diaest));
xmax=min(n(2),round(max(img(m).ptsx)+2*others.diaest));
ymin=max(1,round(min(img(m).ptsy)-2*others.diaest));
ymax=min(n(1),round(max(img(m).ptsy)+2*others.diaest));

if c==4,
    fimg=mean(single(img(m).image(ymin:ymax,xmin:xmax,:)),3);
else
    fimg=single(img(m).image(ymin:ymax,xmin:xmax,c));
end

if r<1
    [fimgx,fimgy]=gradient(fimg);
else
    f=i_gauss(r,r/5);
    if edgetype==1,
        [fimgx,fimgy]=gradient(conv2(fimg,f,'same'));
    elseif edgetype==2,
        [fimgx,fimgy]=gradient(conv2(fimg,f,'same'));
        fimgx=-fimgx;
        fimgy=-fimgy;
    elseif edgetype==3|edgetype==4,
        [fimgx,fimgy]=gradient(conv2(fimg,f,'same'));
        fimgx(:,2:end-1)=-fimgx(:,1:end-2)+fimgx(:,3:end);
        fimgy(2:end-1,:)=-fimgy(1:end-2,:)+fimgy(3:end,:);
    end
end

% calculate the velocity vectors of the selected points
vx(1:img(m).npts)=0.0;
vy(1:img(m).npts)=0.0;
mm=0;
if length(img)>1,
    if m>1,
       if img(m).npts==img(m-1).npts;
            mm=m-1;
            vx=img(m).ptsx-img(mm).ptsx;
            vy=img(m).ptsy-img(mm).ptsy;
       end
    end
    if mm==0 & m<length(img),
       if img(m).npts==img(m+1).npts;
            mm=m+1;
            vx=img(mm).ptsx-img(m).ptsx;
            vy=img(mm).ptsy-img(m).ptsy;
        end 
    end
end
vx(others.roottip)=0.0;
vy(others.roottip)=0.0;
v=sqrt(vx.*vx+vy.*vy);
    
for i=2:img(m).npts,
  if v(i)<=eps,
   vx(i)=img(m).ptsx(i)-img(m).ptsx(i-1);
   vy(i)=img(m).ptsy(i)-img(m).ptsy(i-1);
   v(i)=sqrt(vx(i)*vx(i)+vy(i)*vy(i));
   if v(i)>eps
       vx(i)=vx(i)/v(i);
       vy(i)=vy(i)/v(i);
   end
  else
   vx(i)=vx(i)/v(i);
   vy(i)=vy(i)/v(i);
  end
end

% now find the root edge - 1st iteration
nn=size(fimg);
nx=round(others.diaest)*2;
dx=1.1*others.diaest/nx;

for i=2:img(m).npts,
  x=img(m).ptsx(i)+vy(i)*dx*(0:nx)-xmin+1;
  y=img(m).ptsy(i)-vx(i)*dx*(0:nx)-ymin+1;
  nx1=max(1,round(min(x)-3));
  nx2=min(nn(2),round(max(x)+3));
  ny1=max(1,round(min(y)-3));
  ny2=min(nn(1),round(max(y)+3));
  [ix,iy]=meshgrid(nx1:nx2,ny1:ny2);
  gx=interp2(ix-nx1+1,iy-ny1+1,fimgx(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  gy=interp2(ix-nx1+1,iy-ny1+1,fimgy(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  g=-vy(i)*gx+vx(i)*gy;
  [gmax,gmaxi]=max(g);
  img(m).rootdia1x(i)=x(gmaxi)+xmin-1;
  img(m).rootdia1y(i)=y(gmaxi)+ymin-1;
  g=sqrt(gx(gmaxi)^2+gy(gmaxi)^2);
  vx(i)=gx(gmaxi)/g;
  vy(i)=gy(gmaxi)/g;
end
img(m).rootdia1x(1)=img(m).ptsx(1);
img(m).rootdia1y(1)=img(m).ptsy(1);

for i=2:img(m).npts,
  x=img(m).ptsx(i)+vx(i)*dx*(0:nx)-xmin+1;
  y=img(m).ptsy(i)+vy(i)*dx*(0:nx)-ymin+1;
  nx1=max(1,round(min(x)-3));
  nx2=min(nn(2),round(max(x)+3));
  ny1=max(1,round(min(y)-3));
  ny2=min(nn(1),round(max(y)+3));
  [ix,iy]=meshgrid(nx1:nx2,ny1:ny2);
  gx=interp2(ix-nx1+1,iy-ny1+1,fimgx(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  gy=interp2(ix-nx1+1,iy-ny1+1,fimgy(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  g=-vx(i)*gx-vy(i)*gy;
  [gmax,gmaxi]=max(g);
  img(m).rootdia2x(i)=x(gmaxi)+xmin-1;
  img(m).rootdia2y(i)=y(gmaxi)+ymin-1;
end
img(m).rootdia2x(1)=img(m).ptsx(1);
img(m).rootdia2y(1)=img(m).ptsy(1);

img(m).cen_x=(img(m).rootdia1x+img(m).rootdia2x)/2;
img(m).cen_y=(img(m).rootdia1y+img(m).rootdia2y)/2;

%define root center for 2nd iteration        
cx(1)=img(m).ptsx(1);
cy(1)=img(m).ptsy(1);
for i=2:img(m).npts,
 [cx(i),cy(i)]=drop_normal(img(m).cen_x,img(m).cen_y,img(m).ptsx(i),img(m).ptsy(i));  
end
img(m).cen_x=cx;
img(m).cen_y=cy;

%define root center for 2nd iteration        
cx(1)=img(m).ptsx(1);
cy(1)=img(m).ptsy(1);
for i=2:img(m).npts,
 [cx(i),cy(i)]=drop_normal(img(m).cen_x,img(m).cen_y,img(m).ptsx(i),img(m).ptsy(i));  
end
img(m).cen_x=cx;
img(m).cen_y=cy;

%root edge - 2nd iteration
vx(1)=0.0;
vy(1)=0.0;

for i=2:img(m).npts,
   vx(i)=img(m).cen_x(i)-img(m).cen_x(i-1);
   vy(i)=img(m).cen_y(i)-img(m).cen_y(i-1);
   v(i)=sqrt(vx(i)*vx(i)+vy(i)*vy(i));
   if v(i)>eps,
       vx(i)=vx(i)/v(i);
       vy(i)=vy(i)/v(i);
   end
end

for i=2:img(m).npts,
  x=img(m).cen_x(i)+vy(i)*dx*(0:nx)-xmin+1;
  y=img(m).cen_y(i)-vx(i)*dx*(0:nx)-ymin+1;
  nx1=max(1,round(min(x)-3));
  nx2=min(nn(2),round(max(x)+3));
  ny1=max(1,round(min(y)-3));
  ny2=min(nn(1),round(max(y)+3));
  [ix,iy]=meshgrid(nx1:nx2,ny1:ny2);
  gx=interp2(ix-nx1+1,iy-ny1+1,fimgx(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  gy=interp2(ix-nx1+1,iy-ny1+1,fimgy(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  g=-vy(i)*gx+vx(i)*gy;
  [gmax,gmaxi]=max(g);
  img(m).rootdia1x(i)=x(gmaxi)+xmin-1;
  img(m).rootdia1y(i)=y(gmaxi)+ymin-1;
end

for i=1:img(m).npts,
  x=img(m).cen_x(i)-vy(i)*dx*(0:nx)-xmin+1;
  y=img(m).cen_y(i)+vx(i)*dx*(0:nx)-ymin+1;
  nx1=max(1,round(min(x)-3));
  nx2=min(nn(2),round(max(x)+3));
  ny1=max(1,round(min(y)-3));
  ny2=min(nn(1),round(max(y)+3));
  [ix,iy]=meshgrid(nx1:nx2,ny1:ny2);
  gx=interp2(ix-nx1+1,iy-ny1+1,fimgx(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  gy=interp2(ix-nx1+1,iy-ny1+1,fimgy(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  g=vy(i)*gx-vx(i)*gy;
  [gmax,gmaxi]=max(g);
  img(m).rootdia2x(i)=x(gmaxi)+xmin-1;
  img(m).rootdia2y(i)=y(gmaxi)+ymin-1;
end

img(m).cen_x=(img(m).rootdia1x+img(m).rootdia2x)/2;
img(m).cen_y=(img(m).rootdia1y+img(m).rootdia2y)/2;

%root center for third iteration

cx(1)=img(m).ptsx(1);
cy(1)=img(m).ptsy(1);
for i=2:img(m).npts,
 [cx(i),cy(i)]=drop_normal(img(m).cen_x,img(m).cen_y,img(m).ptsx(i),img(m).ptsy(i));
end

idx1=(0:img(m).npts-1)/(img(m).npts-1);
idx2=0:1/nseg:1;

img(m).cen_x=interp1(idx1,cx,idx2,'linear');
img(m).cen_y=interp1(idx1,cy,idx2,'linear');

clear vx vy;
ncs=length(img(m).cen_x);
vx(1)=img(m).cen_x(2)-img(m).cen_x(1);
vy(1)=img(m).cen_y(2)-img(m).cen_y(1);
for i=2:ncs-1,
    vx(i)=0.5*(img(m).cen_x(i+1)-img(m).cen_x(i-1));
    vy(i)=0.5*(img(m).cen_y(i+1)-img(m).cen_y(i-1));
end
vx(ncs)=img(m).cen_x(ncs)-img(m).cen_x(ncs-1);
vy(ncs)=img(m).cen_y(ncs)-img(m).cen_y(ncs-1);

v=sqrt(vx.*vx+vy.*vy);
vx=vx./v;
vy=vy./v;

clear cx cy;
cx(1)=img(m).ptsx(1);
cy(1)=img(m).ptsy(1);

for i=2:ncs,
  x=img(m).cen_x(i)+vy(i)*dx*(0:nx)-xmin+1;
  y=img(m).cen_y(i)-vx(i)*dx*(0:nx)-ymin+1;
  nx1=max(1,round(min(x)-3));
  nx2=min(nn(2),round(max(x)+3));
  ny1=max(1,round(min(y)-3));
  ny2=min(nn(1),round(max(y)+3));
  [ix,iy]=meshgrid(nx1:nx2,ny1:ny2);
  gx=interp2(ix-nx1+1,iy-ny1+1,fimgx(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  gy=interp2(ix-nx1+1,iy-ny1+1,fimgy(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  g=-vy(i)*gx+vx(i)*gy;
  [gmax,gmaxi]=max(g);
  cx(i)=x(gmaxi)+xmin-1;
  cy(i)=y(gmaxi)+ymin-1;
end
img(m).rootdia1x=cx;
img(m).rootdia1y=cy;

for i=2:ncs,
  x=img(m).cen_x(i)-vy(i)*dx*(0:nx)-xmin+1;
  y=img(m).cen_y(i)+vx(i)*dx*(0:nx)-ymin+1;
  nx1=max(1,round(min(x)-3));
  nx2=min(nn(2),round(max(x)+3));
  ny1=max(1,round(min(y)-3));
  ny2=min(nn(1),round(max(y)+3));
  [ix,iy]=meshgrid(nx1:nx2,ny1:ny2);
  gx=interp2(ix-nx1+1,iy-ny1+1,fimgx(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  gy=interp2(ix-nx1+1,iy-ny1+1,fimgy(ny1:ny2,nx1:nx2),x-nx1+1,y-ny1+1,'cubic');
  g=vy(i)*gx-vx(i)*gy;
  [gmax,gmaxi]=max(g);
  cx(i)=x(gmaxi)+xmin-1;
  cy(i)=y(gmaxi)+ymin-1;
end
img(m).rootdia2x=cx;
img(m).rootdia2y=cy;

img(m).cen_x=(img(m).rootdia1x+img(m).rootdia2x)/2;
img(m).cen_y=(img(m).rootdia1y+img(m).rootdia2y)/2;
img(m).edge_flag=1;

return

%======================================================

function col_channel_check

global img hdl others;

if get(hdl.col_channel_check,'value')==1,
    channelimagedraw(others.cimage,get(hdl.col_channel,'value'));
else
    imagedraw(others.cimage);
end

drawothers(others.cimage);

return

%======================================================
function res = i_gauss(x_dim,sigma)
% Sigma is the standard deviation of the gaussian function
n = x_dim;           % Dimensions of gaussian mask matrix i.e., nxn
for i = 1:n,
    for j = 1:n
        M_temp = [j-(n+1)/2 i-(n+1)/2]';       
        M(i,j) = gauss(M_temp(1),sigma)*gauss(M_temp(2),sigma); % mask
    end
end
res = M/sum(sum(M)); % to normalize the mask

return

%----------------------------------------------------------
%Function to calculate Gaussian function
function res = gauss(x,sigma)

res = exp(-x^2/(2*sigma^2))/(sigma*sqrt(2*pi));

return

%---------------------------------------------------------

function midline

global hdl others;

others.midline=get(hdl.midlinebtn,'value');
set(hdl.outlinebtn,'value',abs(1-others.midline));

if others.midline==1,
    set(hdl.diaestimate,'enable','off');
    set(hdl.edgetypetext,'enable','off');
    set(hdl.edgetype,'enable','off');
    set(hdl.algotext,'enable','off');
    set(hdl.algorithm,'enable','off');
    set(hdl.rootdia,'enable','off');
    set(hdl.rootdia_all,'enable','off');
    set(hdl.rootdiatext,'enable','off');
    set(hdl.filtertext,'enable','off');
    set(hdl.filterrad,'enable','off');
    set(hdl.diaadjust,'enable','off');
    findmidline;
    drawothers(others.cimage);
 else
    set(hdl.diaestimate,'enable','on');
    set(hdl.edgetypetext,'enable','on');
    set(hdl.edgetype,'enable','on');
    set(hdl.algotext,'enable','on');
    set(hdl.algorithm,'enable','on');
    set(hdl.rootdia,'enable','on');
    set(hdl.rootdia_all,'enable','on');
    set(hdl.rootdiatext,'enable','on');
    set(hdl.filtertext,'enable','on');
    set(hdl.filterrad,'enable','on');
    set(hdl.diaadjust,'enable','on');
end

return

%---------------------------------------------------------

function edgedetection

global hdl others;

others.midline=abs(get(hdl.outlinebtn,'value')-1);
set(hdl.midlinebtn,'value',others.midline);

if others.midline==1,
    set(hdl.diaestimate,'enable','off');
    set(hdl.edgetypetext,'enable','off');
    set(hdl.edgetype,'enable','off');
    set(hdl.algotext,'enable','off');
    set(hdl.algorithm,'enable','off');
    set(hdl.rootdia,'enable','off');
    set(hdl.rootdia_all,'enable','off');
    set(hdl.rootdiatext,'enable','off');
    set(hdl.filtertext,'enable','off');
    set(hdl.filterrad,'enable','off');
    set(hdl.diaadjust,'enable','off');
    findmidline;
    drawothers(others.cimage);
else
    set(hdl.diaestimate,'enable','on');
    set(hdl.edgetypetext,'enable','on');
    set(hdl.edgetype,'enable','on');
    set(hdl.algotext,'enable','on');
    set(hdl.algorithm,'enable','on');
    set(hdl.rootdia,'enable','on');
    set(hdl.rootdia_all,'enable','on');
    set(hdl.rootdiatext,'enable','on');
    set(hdl.filtertext,'enable','on');
    set(hdl.filterrad,'enable','on');
    set(hdl.diaadjust,'enable','on');
end
return

%=================================================