function save_results

global hdl img others;

n=length(img);
if n<1,
    return
end

fname=sprintf('%s_kineroot.txt',img(1).filename(1:end-4));
[filename,dir]=uiputfile(fname,'Save results as');

if filename==0
    return
end

filename=sprintf('%s\\%s',dir,filename);

mmax=length(img(1).cen_x);
for i=1:n,
    if img(i).npts>mmax
        mmax=img(i).npts;
    end
end

data(1:n+1,1:6*mmax+3)=0.0;

data(1,1)=others.period;
data(1,2)=others.periodunit;
data(1,3)=others.scale;
data(1,4)=others.unitvalue;
data(1,5)=n;
data(1,6)=others.roottip;
data(1,7)=others.diaest;
data(1,8)=mmax;

for i=1:n,
    data(i+1,1)=i;
    data(i+1,2)=img(i).npts;
    m=img(i).npts;
    ncs=length(img(i).cen_x);
    data(i+1,3)=ncs;
    
    if m>0
        data(i+1,     4:     m+3)=img(i).ptsx(1:m);
        data(i+1,mmax+4:mmax+m+3)=img(i).ptsy(1:m);
        if img(i).edge_flag==1,
            data(i+1,2*mmax+4)=img(i).edge_flag;
            data(i+1,2*mmax+5:2*mmax+ncs+4)=img(i).rootdia1x;
            data(i+1,3*mmax+5:3*mmax+ncs+4)=img(i).rootdia1y;
            data(i+1,4*mmax+5:4*mmax+ncs+4)=img(i).rootdia2x;
            data(i+1,5*mmax+5:5*mmax+ncs+4)=img(i).rootdia2y;
            data(i+1,6*mmax+5:6*mmax+ncs+4)=img(i).cen_x;
            data(i+1,7*mmax+5:7*mmax+ncs+4)=img(i).cen_y;
        end
        data(i+1,8*mmax+5:8*mmax+m+4)=img(i).cc(1:m);
    end
end

save(filename,'data','-ASCII');

return