function savedata(action, varargin)

if nargin>=1,
 feval(action,varargin{:});
end

return

%=============================================

function savetec

global hdl others img results;

fname=sprintf('*.dat');
[filename,dir]=uiputfile(fname,'Save results as');

if filename==0
    return
end

switch others.plotdata
    case 1
        n=0;
        for i=1:length(results),
            for j=1:length(results(i).cen_x)
                n=n+1;
                datax(n)=results(i).time;
                datay(n)=results(i).lc(j);
            end
        end
        xstr=sprintf('Time (%s)',others.timeunit);
        if strncmp(others.unit,'um',2)
            ystr=sprintf('Length from root tip along the centerline <greek>m</greek>m');
        else
            ystr=sprintf('Length from root tip along the centerline (%s)',others.unit);
        end
        tstr='Title="Root growth chart"';
        if ~writestring(filename,tstr,'Overwrite'),
            return
        end
        str=sprintf('variables="%s","%s"',xstr,ystr);
        writestring(filename,str,'Append');
        str=sprintf('Zone I=%d, J=%d, F=POINT',length(results(i).cen_x),length(results));
        writestring(filename,str,'Append');
        writedat(filename,[datax' datay'],'Append');
    case 2
        xstr=get(get(gca,'Xlabel'),'string');
        ystr=get(get(gca,'Ylabel'),'string');
        tstr=sprintf('Title="%s"',get(get(gca,'Title'),'string'));
        if ~writestring(filename,tstr,'Overwrite'),
            return
        end
        str=sprintf('variables="%s","%s"',xstr,ystr);
        writestring(filename,str,'Append');
        n=size(others.t);
        for i=1:n(1),
            str=sprintf('Zone T="Time = %.2f (%s)", F=POINT',others.t(i,1),others.timeunit);
            writestring(filename,str,'Append');
            writedat(filename,[others.x(i,:)',others.p(i,:)'],'Append');
        end
    case 3
        xstr=get(get(gca,'Xlabel'),'string');
        ystr=get(get(gca,'Ylabel'),'string');
        zstr=get(get(gca,'Title'),'string');
        tstr=sprintf('Title="%s"',get(get(gca,'Title'),'string'));
        if ~writestring(filename,tstr,'Overwrite'),
            return
        end
        str=sprintf('variables="%s","%s","%s"',xstr,ystr,zstr);
        writestring(filename,str,'Append');
        n=size(others.t);
        str=sprintf('Zone I=%d, J=%d, F=POINT',n(1),n(2));
        writestring(filename,str,'Append');
        writedat(filename,[reshape(others.t,n(2)*n(1),1), ...
            reshape(others.x,n(2)*n(1),1), ...
            reshape(others.p,n(2)*n(1),1)],'Append');
    case 4
        xstr=get(get(gca,'Xlabel'),'string');
        ystr=get(get(gca,'Ylabel'),'string');
        tstr=sprintf('Title="%s"',get(get(gca,'Title'),'string'));
        if ~writestring(filename,tstr,'Overwrite'),
            return
        end
        str=sprintf('variables="%s","%s"',xstr,ystr);
        writestring(filename,str,'Append');
        n=size(others.t);
        for i=1:n(1),
            str=sprintf('Zone T="Time = %.2f (%s)", F=POINT',others.t(i,1),others.timeunit);
            writestring(filename,str,'Append');
            writedat(filename,[others.x(i,:)',others.p(i,:)'],'Append');
        end
    case 5
        xstr=get(get(gca,'Xlabel'),'string');
        ystr=get(get(gca,'Ylabel'),'string');
        tstr=sprintf('Title="%s"',get(get(gca,'Title'),'string'));
        if ~writestring(filename,tstr,'Overwrite'),
            return
        end
        str=sprintf('variables="%s","%s","SE"',xstr,ystr);
        writestring(filename,str,'Append');
        n=size(others.binx);
        for i=1:n(1),
            writedat(filename,[others.binx(i,:)',others.binp(i,:)',others.binpsd(i,:)'],'Append');
        end
end

return

%=============================================

function savetxt

global hdl others img results;

fname=sprintf('*.txt');
[filename,dir]=uiputfile(fname,'Save results as');

if filename==0
    return
end

switch others.plotdata
    case 1
        tstr=sprintf('Root length data');
        if ~writestring(filename,tstr,'Overwrite'),
            return
        end
        str=sprintf('t(%s)',others.timeunit);
        for i=1:length(results),
            str=sprintf('%s\t%.2f',str,results(i).time);
        end
        writestring(filename,str,'Append');
        for i=1:length(results),
            str=sprintf('x(%s)',others.unit);
            for j=1:length(results(i).cen_x)
                str=sprintf('%s\t%.3f',str,results(i).lc(j));
            end
            writestring(filename,str,'Append');
        end
    case 2
        tstr=sprintf('%s',get(get(gca,'Title'),'string'));
        if ~writestring(filename,tstr,'Overwrite'),
            return
        end
        str=sprintf('t(%s)',others.timeunit);
        for i=1:length(others.t(:,1)),
            str=sprintf('%s\t%.2f',str,others.t(i,1));
        end
        writestring(filename,str,'Append');
        n=size(others.x);
        for j=1:n(2)
            str=sprintf('x(%s)',others.unit);
            for i=1:n(1),
                str=sprintf('%s\t%.3f',str,others.x(i,j));
            end
            writestring(filename,str,'Append');
        end
        str=sprintf('%s',get(get(gca,'Ylabel'),'string'));
        writestring(filename,str,'Append');
        n=size(others.x);
        for j=1:n(2)
            str=sprintf('c');
            for i=1:n(1)
                str=sprintf('%s\t%.3f',str,others.p(i,j));
            end
            writestring(filename,str,'Append');
        end
    case 3
        tstr=sprintf('%s',get(get(gca,'Title'),'string'));
        if ~writestring(filename,tstr,'Overwrite'),
            return
        end
        str=sprintf('t(%s)',others.timeunit);
        for i=1:length(results),
            str=sprintf('%s\t%.2f',str,others.t(i,1));
        end
        writestring(filename,str,'Append');
        n=size(others.x);
        for j=1:n(2)
            str=sprintf('x(%s)',others.unit);
            for i=1:n(1)
                str=sprintf('%s\t%.3f',str,others.x(i,j));
            end
            writestring(filename,str,'Append');
        end
        str=sprintf('%s',get(get(gca,'Title'),'string'));
        writestring(filename,str,'Append');
        n=size(others.x);
        for j=1:n(2)
            str=sprintf('c');
            for i=1:n(1)
                str=sprintf('%s\t%.3f',str,others.p(i,j));
            end
            writestring(filename,str,'Append');
        end
    case 4
        tstr=sprintf('%s',get(get(gca,'Title'),'string'));
        if ~writestring(filename,tstr,'Overwrite'),
            return
        end
        str=sprintf('t(%s)',others.timeunit);
        for i=1:length(results),
            str=sprintf('%s\t%.2f',str,others.t(i,1));
        end
        writestring(filename,str,'Append');
        n=size(others.x);
        for j=1:n(2)
            str=sprintf('x(%s)',others.unit);
            for i=1:n(1)
                str=sprintf('%s\t%.3f',str,others.x(i,j));
            end
            writestring(filename,str,'Append');
        end
        str=sprintf('%s',get(get(gca,'Ylabel'),'string'));
        writestring(filename,str,'Append');
        n=size(others.x);
        for j=1:n(2)
            str=sprintf('c');
            for i=1:n(1)
                str=sprintf('%s\t%.3f',str,others.p(i,j));
            end
            writestring(filename,str,'Append');
        end
    case 5
        xstr=get(get(gca,'Xlabel'),'string');
        ystr=get(get(gca,'Ylabel'),'string');
        tstr=sprintf('%s',get(get(gca,'Title'),'string'));
        if ~writestring(filename,tstr,'Overwrite'),
            return
        end
        str=sprintf('%s\t%s\tSE',xstr,ystr);
        writestring(filename,str,'Append');
        n=size(others.binx);
        for i=1:n(1),
            writedat_tab(filename,[others.binx(i,:)',others.binp(i,:)',others.binpsd(i,:)'],'Append');
        end
end

return

%====================================
function flag=writestring(fname,data,wflag)

flag=1;
n=size(data);
if strcmpi(wflag,'Append'),
    fid=fopen(fname,'a');
else
    fid=fopen(fname,'w');
end

if fid==-1,
    str=sprintf('File %s cannot be opened. Check if it is opened in another program.',fname);
    warndlg(str,'File open error');
    flag=0;
    return
end

if n(2) > 0
 fprintf(fid,'%s\n',data);
else
 fprintf(fid,'\n');
end
fclose(fid);

return

%=====================================

function flag=writedat(fname,data,wflag)

n=size(data);
flag=1;
if n(2) > 0

 f=[];
 for i=1:n(2)
  f=[f ' %.4f'];
 end
 f=[f '\n'];

 if strcmpi(wflag,'Append'),
    fid=fopen(fname,'a');
 else
    fid=fopen(fname,'w');
 end

 if fid==-1,
    str=sprintf('File %s cannot be opened. Check if it is opened in another program.',fname);
    warndlg(str,'File open error');
    flag=0;
    return
 end
 
 for i=1:n(1)
  fprintf(fid,f,data(i,:));
 end

 fclose(fid);
end

return

%=====================================

function flag=writedat_tab(fname,data,wflag)

n=size(data);
flag=1;
if n(2) > 0

 f=[];
 for i=1:n(2)
  f=[f '%.4f\t'];
 end
 f=[f '\n'];

 if strcmpi(wflag,'Append'),
    fid=fopen(fname,'a');
 else
    fid=fopen(fname,'w');
 end

 if fid==-1,
    str=sprintf('File %s cannot be opened. Check if it is opened in another program.',fname);
    warndlg(str,'File open error');
    flag=0;
    return
 end
 
 for i=1:n(1)
  fprintf(fid,f,data(i,:));
 end

 fclose(fid);
end

return