function scaleok

global hdl img others;

others.period=str2num(get(hdl.period,'string'));
others.periodunit=get(hdl.periodunit,'value');

switch others.periodunit
    case 1
       others.timeunit='ms';
    case 2
       others.timeunit='sec';
    case 3
       others.timeunit='min';
    case 4
       others.timeunit='hour';
    case 5
        others.timeunit='day';
    case 6
        others.timeunit='week';
end
for i=1:length(img),
    img(i).time=(i-1)*others.period;
end

d1=str2num(get(hdl.scale,'string'));
d2=str2num(get(hdl.spixel,'string'));
if d1 > 0 | d2 > 0,
    others.scale=d2/d1;
    others.unitvalue=get(hdl.sunit,'value');
    switch others.unitvalue
        case 1
            others.unit='cm';
            others.matunit='cm';
        case 2
            others.unit='mm';
            others.matunit='mm';
        case 3
            others.unit='in';
            others.matunit='in';
        case 4
            others.unit='px';
            others.matunit='px';
        case 5
            others.unit='um';
            others.matunit='\mum';
    end
    str=sprintf('Scale Info:\n %.2f px = 1 %s',others.scale,others.unit);
    set(hdl.scaleheading,'string',str);
else
    others.scale=0;
    errordlg('Check measurement and equivalent length.');
end

if hdl.scaleline>0
    delete(hdl.scaleline);
    hdl.scaleline=-1;
end

imagedraw(others.cimage);
drawothers(others.cimage);

return