function pmax=track_a_pt(m,i,j,ref,ptrad,srad)

global img hdl others history;

tmethod=get(hdl.trackmethod,'value');
hist=get(hdl.history,'value')-1;

flag=get(hdl.trackdirectional,'value');
if flag==1,
  flag=0;
  n=m+(m-i);
  if n>0 & n<=length(img),
      if img(n).npts==img(m).npts,
         flag=1;
      end
  end
end

p=size(img(i).image);
if strncmp(others.color,'of',2)
    p(3)=1;
end
x0=img(m).ptsx(j);
y0=img(m).ptsy(j);
px=x0;
py=y0;
  
x0l=round(max(1,x0-ptrad));
x0r=round(min(p(2),x0+ptrad));
y0u=round(max(1,y0-ptrad));
y0d=round(min(p(1),y0+ptrad));
p0=double(img(m).image(y0u:y0d,x0l:x0r,:));



for k=1:p(3),
    p0m(:,:,k)=p0(:,:,k)-mean(mean(p0(:,:,k)));
    p0ms(k)=sum(sum(p0m(:,:,k).*p0m(:,:,k)));
end

hcount=0;
if hist>0 & ref~=m,
  hcount=hcount+1;
  x00=img(ref).ptsx(j);
  y00=img(ref).ptsy(j);
  x00l=round(max(1,x00-ptrad));
  x00r=round(min(p(2),x00+ptrad));
  y00u=round(max(1,y00-ptrad));
  y00d=round(min(p(1),y00+ptrad));
  p00=double(img(ref).image(y00u:y00d,x00l:x00r,:));
  history(hcount).p1=p00;
  for k=1:p(3),
    history(hcount).p0m(:,:,k)=p00(:,:,k)-mean(mean(p00(:,:,k)));
    history(hcount).p0ms(k)=sum(sum(history(hcount).p0m(:,:,k).^2));
  end
  for kk=2:hist
          nn=sign(ref-m)*(kk-1)+m;
          if nn==ref
              break;
          end
          hcount=hcount+1;
          x00=img(nn).ptsx(j);
          y00=img(nn).ptsy(j);
          x00l=round(max(1,x00-ptrad));
          x00r=round(min(p(2),x00+ptrad));
          y00u=round(max(1,y00-ptrad));
          y00d=round(min(p(1),y00+ptrad));
          p00=double(img(nn).image(y00u:y00d,x00l:x00r,:)); 
          history(hcount).p1=p00;
          for k=1:p(3),
           history(hcount).p0m(:,:,k)=p00(:,:,k)-mean(mean(p00(:,:,k)));
           history(hcount).p0ms(k)=sum(sum(history(hcount).p0m(:,:,k).^2));
          end
  end
end

vx=0;
vy=0;
if flag==1,
    vx=img(m).ptsx(j)-img(n).ptsx(j);
    vy=img(m).ptsy(j)-img(n).ptsy(j);
    xsl=round(max(1,x0+vx-srad));
    xsr=round(min(p(2),x0+vx+srad));
    ysu=round(max(1,y0+vy-srad));
    ysd=round(min(p(1),y0+vy+srad));
else
    xsl=round(max(1,x0-srad));
    xsr=round(min(p(2),x0+srad));
    ysu=round(max(1,y0-srad));
    ysd=round(min(p(1),y0+srad));
end



col=get(hdl.col_channel,'value');


switch tmethod
  case 1
% color correlation method
    if hist==0,
        if j==others.roottip,
         [px,py,pmax]=color_correlation(p,p0,p0m,p0ms,xsl,xsr,ysu,ysd,vx,vy,x0,y0,i,ptrad,col);
        else
         [px,py,pmax]=correlation(p,p0,p0m,p0ms,xsl,xsr,ysu,ysd,vx,vy,x0,y0,i,ptrad,col);
        end
    else
        if j==others.roottip,
         [px,py,pmax]=color_correlation_ref(p,p0,p0m,p0ms,hcount,xsl,xsr,ysu,ysd,vx,vy,x0,y0,i,ptrad,col);
         clear global history;
        else
         [px,py,pmax]=correlation_ref(p,p0,p0m,p0ms,hcount,xsl,xsr,ysu,ysd,vx,vy,x0,y0,i,ptrad,col);
         clear global history;
        end 
    end
      
  case 2
% correlation method
    if hist==0,
        [px,py,pmax]=correlation(p,p0,p0m,p0ms,xsl,xsr,ysu,ysd,vx,vy,x0,y0,i,ptrad,col);
    else
        [px,py,pmax]=correlation_ref(p,p0,p0m,p0ms,hcount,xsl,xsr,ysu,ysd,vx,vy,x0,y0,i,ptrad,col);
        clear global history;
    end
    
  case 3
%Difference method
    if hist==0,
        [px,py,pmax]=difference(p,p0,xsl,xsr,ysu,ysd,vx,vy,x0,y0,i,ptrad,col);
    else
        [px,py,pmax]=difference_ref(p,p0,hcount,xsl,xsr,ysu,ysd,vx,vy,x0,y0,i,ptrad,col);
        clear global history;
    end
          
  case 4
%Correlation+Difference method
    if hist==0,
        [px,py,pmax]=corr_diff(p,p0,p0m,p0ms,xsl,xsr,ysu,ysd,vx,vy,x0,y0,i,ptrad,col);
    else
        [px,py,pmax]=corr_diff_ref(p,p0,p0m,p0ms,hcount,xsl,xsr,ysu,ysd,vx,vy,x0,y0,i,ptrad,col);
        clear global history;
    end          
end

img(i).npts=j;
img(i).ptsx(j)=px;
img(i).ptsy(j)=py;


return