#!/usr/bin/R
#script for plotting simroot verification

#I want to use different colors and linetypes for the simulation lines and symbols for the measurements
#these arrays are 3 long for I have three types of data that I want to plot
colors=c(1,2,3)
linetypes=c(1,2,3)
symbols=c(1,2,3)
#I want to plot two graphs from two files
files=c("SimRoot Verification Bean.csv","SimRoot Verification Maize.csv")
#these files contain data for two different plants
plants=c("bean","maize")

   #set plot parameters - I want to write my plot to an svg file 
   #svg files are vector graphics that can be edited in inkscape.
   svg(filename="verification_color.svg",width=14,height=7)
   #two graphs with large text and symbols and decent margins
   par(mfcol=c(1,2),ps=20,lwd=4,bty='u' ,mar=c(5,4,4,4) + 0.50) 
#loop over the plants    
for (plant in plants){ 
   #read data from that plant
   read.csv(files[plants==plant],header=T)->d
   #transform the data a bit. This is necessary for the data plot on the secondary y axis
   scale=10
   d[,6]=d[,6]/scale
   d[,7]=d[,7]/scale
   #set the labels of the x and y axis
   xlab="time (days aft. germ.)"
   ylab="dry weight (g)"
   #set the range of the x and y axis
   xmin=min(d[,1], na.rm = T)
   xmax=max(d[,1], na.rm = T)
   ymin=min(d[,2],d[,3],d[,4],d[,5],d[,6],d[,7], na.rm = T)
   ymax=ceiling(max(d[,2],d[,3],d[,4],d[,5],d[,6],d[,7], na.rm = T)) #I use ceil to get a round of value for the max on the y-axis
   #plot all lines and symbols
   plot(d[,1],d[,6], col=colors[1],xlab=xlab,ylab=ylab,ylim=c(ymin,ymax),pch=symbols[1])
   lines( d[,1],d[,7], col=colors[1],lty=linetypes[1])
   points( d[,1],d[,2],col=colors[2],pch=symbols[2])
   lines( d[,1],d[,3],col=colors[2],lty=linetypes[2])
   points( d[,1],d[,4],col=colors[3],pch=symbols[3])
   lines( d[,1],d[,5],col=colors[3],lty=linetypes[3])
   #add the secondary y axis
   at=pretty(range(c(ymin,ymax)))
   axis(4, at=at, labels=scale*at) 
   mtext("root length (m)",4,3)
   #add a legend in the plot (I only want to have the legend in the right plot
   if(plant=="maize"){
      legend(xmin,ymax,legend=c("root length","shoot dry weight","root dry weight"),col=colors,pch=symbols,lty=linetypes,bty='n',y.intersp=1.3)
   }
   #add a title to the plot
   title(plant)
}
#close the plotting device
dev.off() 
#we are done, look at your filesystem to see the graph
